/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.xmldb.EXistResource;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XMLDBSize
extends XMLDBAbstractCollectionManipulator {
    public static final FunctionSignature signature = new FunctionSignature(new QName("size", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the estimated size of a resource (in bytes) in the collection specified by $a. The estimation is based on the number of pages occupied by a resource. If the document is serialized back to a string, it's size may be different, as parts of the structural information are stored in compressed form. The collection can be passed as a simple collection path, an XMLDB URI or a collection object (obtained from the collection function).", new SequenceType[]{new SequenceType(11, 2), new SequenceType(22, 2)}, new SequenceType(37, 2));

    public XMLDBSize(XQueryContext context) {
        super(context, signature);
    }

    protected Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            Resource resource = collection.getResource(args[1].getStringValue());
            return new IntegerValue(((EXistResource)resource).getContentLength(), 37);
        }
        catch (XMLDBException e) {
            throw new XPathException(this.getASTNode(), "Failed to retrieve size: " + e.getMessage(), e);
        }
    }
}

