/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.security.Permission;
import org.exist.security.User;
import org.exist.xmldb.UserManagementService;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class XMLDBSetCollectionPermissions
extends XMLDBAbstractCollectionManipulator {
    public static final FunctionSignature signature = new FunctionSignature(new QName("set-collection-permissions", "http://exist-db.org/xquery/xmldb", "xmldb"), "Sets the permissions of the specified Collection. Required: user, group, mode (as xs:integer). PLEASE REMEMBER that 0755 is 7*64+5*8+5, NOT decimal 755.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(31, 2)}, new SequenceType(11, 1));

    public XMLDBSetCollectionPermissions(XQueryContext context) {
        super(context, signature);
    }

    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            UserManagementService ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
            String user = args[1].getStringValue();
            String group = args[2].getStringValue();
            int mode = ((IntegerValue)args[3].convertTo(31)).getInt();
            if (null == user || 0 == user.length()) {
                throw new XPathException(this.getASTNode(), "Needs a valid user name, not: " + user);
            }
            if (null == group || 0 == group.length()) {
                throw new XPathException(this.getASTNode(), "Needs a valid group name, not: " + group);
            }
            Permission p = new Permission(user, group, mode);
            User u = ums.getUser(user);
            if (null == u) {
                throw new XPathException(this.getASTNode(), "Needs a valid user name, not: " + user);
            }
            p.setOwner(u);
            ums.setPermissions(collection, p);
        }
        catch (XMLDBException xe) {
            throw new XPathException(this.getASTNode(), "Unable to change collection permissions", xe);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

