/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.security.Permission;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBPermissions;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class XMLDBGetUserOrGroup
extends XMLDBPermissions {
    public static final FunctionSignature[] getGroupSignatures = new FunctionSignature[]{new FunctionSignature(new QName("get-group", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the owner group of a collection. The collection can be passed as a simple collection path, an XMLDB URI or a collection object (obtained from the collection function).", new SequenceType[]{new SequenceType(11, 2)}, new SequenceType(22, 3)), new FunctionSignature(new QName("get-group", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the owner group of a resource in the collection specified by $a. The collection can be passed as a simple collection path, an XMLDB URI or a collection object (obtained from the collection function).", new SequenceType[]{new SequenceType(11, 2), new SequenceType(22, 2)}, new SequenceType(22, 3))};
    public static final FunctionSignature[] getOwnerSignatures = new FunctionSignature[]{new FunctionSignature(new QName("get-owner", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the owner of a collection. The collection can be passed as a simple collection path, an XMLDB URI or a collection object (obtained from the collection function).", new SequenceType[]{new SequenceType(11, 2)}, new SequenceType(22, 3)), new FunctionSignature(new QName("get-owner", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the owner of the specified resource $b in collection $a. The collection can be passed as a simple collection path, an XMLDB URI or a collection object (obtained from the collection function).", new SequenceType[]{new SequenceType(11, 2), new SequenceType(22, 2)}, new SequenceType(22, 3))};

    public XMLDBGetUserOrGroup(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            Permission perm = this.getPermissions(collection, args);
            if ("get-owner".equals(this.getSignature().getName().getLocalName())) {
                return new StringValue(perm.getOwner());
            }
            return new StringValue(perm.getOwnerGroup());
        }
        catch (XMLDBException xe) {
            throw new XPathException(this.getASTNode(), "Unable to retrieve resource permissions", xe);
        }
    }
}

