/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class XMLDBCollectionExists
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("collection-exists", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns true as xs:boolean if there is a collection with the same name as the first argument as xs:string.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(23, 2));

    public XMLDBCollectionExists(XQueryContext context) {
        super(context, signature);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        BooleanValue booleanValue;
        Collection collection;
        block8: {
            String collectionURI = args[0].getStringValue();
            collection = null;
            try {
                try {
                    collection = DatabaseManager.getCollection((String)collectionURI);
                }
                catch (XMLDBException e) {
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                    throw new XPathException(this.getASTNode(), "exception while retrieving collection: " + e.getMessage(), e);
                }
                Object var7_5 = null;
                if (null == collection) break block8;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (null == collection) throw throwable;
                try {
                    collection.close();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new XPathException(this.getASTNode(), "Unable to close collection", e);
                }
            }
            try {}
            catch (Exception e) {
                throw new XPathException(this.getASTNode(), "Unable to close collection", e);
            }
            collection.close();
        }
        if (null == collection) {
            booleanValue = BooleanValue.FALSE;
            return booleanValue;
        }
        booleanValue = BooleanValue.TRUE;
        return booleanValue;
    }
}

