/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.xmldb.LocalCollection;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class XMLDBCollection
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("collection", "http://exist-db.org/xquery/xmldb", "xmldb"), "Get a reference to a collection. The collection is identified by the first argument, which is either a collection path like '/db' or an XMLDB URI like 'xmldb:exist://localhost:8081/db'. The second argument should specify the name of a valid user, the third is the password. The method returns a Java object type, which can then be used as argument to the create-collection or store functions.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(100, 3));

    public XMLDBCollection(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String collectionURI = args[0].getStringValue();
        String user = args[1].getStringValue();
        String passwd = args[2].getStringValue();
        Collection collection = null;
        try {
            if (!collectionURI.startsWith("xmldb:")) {
                User localUser = this.context.getUser();
                if (!localUser.getName().equals(user)) {
                    localUser = this.getUser(user, passwd);
                }
                collection = new LocalCollection(localUser, this.context.getBroker().getBrokerPool(), collectionURI);
            } else {
                collection = DatabaseManager.getCollection((String)collectionURI, (String)user, (String)passwd);
            }
        }
        catch (XMLDBException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            throw new XPathException(this.getASTNode(), "exception while retrieving collection: " + e.getMessage(), e);
        }
        return collection == null ? Sequence.EMPTY_SEQUENCE : new JavaObjectValue(collection);
    }

    private User getUser(String user, String passwd) throws XPathException {
        SecurityManager secman = this.context.getBroker().getBrokerPool().getSecurityManager();
        User u = secman.getUser(user);
        if (!u.validate(passwd)) {
            throw new XPathException(this.getASTNode(), "Wrong password specified for user " + user);
        }
        return u;
    }
}

