/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.collections.Collection;
import org.exist.dom.NodeProxy;
import org.exist.xmldb.LocalCollection;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.XMLDBException;

public abstract class XMLDBAbstractCollectionManipulator
extends BasicFunction {
    public XMLDBAbstractCollectionManipulator(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (0 == args.length) {
            throw new XPathException("Expected a collection as the first argument.");
        }
        boolean collectionNeedsClose = true;
        org.xmldb.api.base.Collection collection = null;
        Item item = args[0].itemAt(0);
        if (item.getType() == 100) {
            Object o = ((JavaObjectValue)item).getObject();
            if (o instanceof org.xmldb.api.base.Collection) {
                collection = (org.xmldb.api.base.Collection)o;
            }
        } else if (Type.subTypeOf(item.getType(), -1)) {
            NodeValue node = (NodeValue)item;
            LOG.debug((Object)"Found node");
            if (node.getImplementationType() != 1) return Sequence.EMPTY_SEQUENCE;
            Collection internalCol = ((NodeProxy)node).getDocument().getCollection();
            LOG.debug((Object)"Found node");
            try {
                collection = new LocalCollection(this.context.getUser(), this.context.getBroker().getBrokerPool(), internalCol.getName());
                LOG.debug((Object)("Loaded collection " + collection.getName()));
            }
            catch (XMLDBException e) {
                throw new XPathException(this.getASTNode(), "Failed to access collection: " + internalCol.getName(), e);
            }
        }
        if (null == collection) {
            String collectionURI = args[0].getStringValue();
            if (null != collectionURI) {
                try {
                    collection = !collectionURI.startsWith("xmldb:") ? new LocalCollection(this.context.getUser(), this.context.getBroker().getBrokerPool(), collectionURI) : DatabaseManager.getCollection((String)collectionURI);
                }
                catch (XMLDBException xe) {
                    throw new XPathException(this.getASTNode(), "Could not locate collection: " + collectionURI, xe);
                }
            }
            if (null == collection) {
                throw new XPathException(this.getASTNode(), "Unable to find collection: " + collectionURI);
            }
        } else {
            collectionNeedsClose = false;
        }
        Sequence s = Sequence.EMPTY_SEQUENCE;
        try {
            s = this.evalWithCollection(collection, args, contextSequence);
            Object var10_10 = null;
            if (!collectionNeedsClose) return s;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (!collectionNeedsClose) throw throwable;
            try {
                collection.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new XPathException(this.getASTNode(), "Unable to close collection", e);
            }
        }
        try {
            collection.close();
            return s;
        }
        catch (Exception e) {
            throw new XPathException(this.getASTNode(), "Unable to close collection", e);
        }
    }

    protected abstract Sequence evalWithCollection(org.xmldb.api.base.Collection var1, Sequence[] var2, Sequence var3) throws XPathException;
}

