/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.StringReader;
import org.exist.dom.DocumentSet;
import org.exist.dom.QName;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryLexer;
import org.exist.xquery.parser.XQueryParser;
import org.exist.xquery.parser.XQueryTreeParser;
import org.exist.xquery.value.EmptySequence;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class EvalFunction
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("eval", "http://exist-db.org/xquery/util", "util"), "Dynamically evaluates its string argument as an XPath/XQuery expression. The argument expression will inherit the current execution context, i.e. all namespace declarations and variable declarations are visible from within the inner expression. The function accepts a second string argument to specify the static context collection to which the expression applies. It will returnan empty sequence if you pass a whitespace string.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(-1, 7), true);

    public EvalFunction(XQueryContext context) {
        super(context, signature);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        String expr = StringValue.expand(this.getArgument(0).eval(contextSequence, contextItem).getStringValue());
        if ("".equals(expr.trim())) {
            return new EmptySequence();
        }
        DocumentSet oldDocumentSet = null;
        if (this.getArgumentCount() > 1) {
            oldDocumentSet = this.context.getStaticallyKnownDocuments();
            Sequence collectionArgs = this.getArgument(1).eval(contextSequence, contextItem);
            if (collectionArgs.getLength() > 0) {
                this.context.setStaticallyKnownDocuments(this.getCollectionContext(collectionArgs));
            }
        }
        this.context.pushNamespaceContext();
        LOG.debug((Object)("eval: " + expr));
        XQueryLexer lexer = new XQueryLexer(this.context, new StringReader(expr));
        XQueryParser parser = new XQueryParser(lexer);
        XQueryTreeParser astParser = new XQueryTreeParser(this.context);
        try {
            try {
                parser.xpath();
                if (parser.foundErrors()) {
                    LOG.debug((Object)parser.getErrorMessage());
                    throw new XPathException("error found while executing expression: " + parser.getErrorMessage());
                }
                AST ast = parser.getAST();
                PathExpr path = new PathExpr(this.context);
                astParser.xpath(ast, path);
                if (astParser.foundErrors()) {
                    throw new XPathException("error found while executing expression: " + astParser.getErrorMessage(), astParser.getLastException());
                }
                long start = System.currentTimeMillis();
                Sequence sequence = path.eval(null, null);
                path.reset();
                LOG.debug((Object)("Found " + sequence.getLength() + " for " + expr));
                LOG.debug((Object)("Query took " + (System.currentTimeMillis() - start)));
                Sequence sequence2 = sequence;
                Object var15_15 = null;
                if (oldDocumentSet != null) {
                    this.context.setStaticallyKnownDocuments(oldDocumentSet);
                }
                this.context.popNamespaceContext();
                return sequence2;
            }
            catch (RecognitionException e) {
                throw new XPathException("error found while executing eval expression: " + e.getMessage(), e.getLine(), e.getColumn());
            }
            catch (TokenStreamException e) {
                throw new XPathException(this.getASTNode(), e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (oldDocumentSet != null) {
                this.context.setStaticallyKnownDocuments(oldDocumentSet);
            }
            this.context.popNamespaceContext();
            throw throwable;
        }
    }

    private String[] getCollectionContext(Sequence arg) throws XPathException {
        String[] collections = new String[arg.getLength()];
        int j = 0;
        SequenceIterator i = arg.iterate();
        while (i.hasNext()) {
            String collection;
            collections[j] = collection = i.nextItem().getStringValue();
            ++j;
        }
        return collections;
    }
}

