/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class DocumentNameOrId
extends BasicFunction {
    public static final FunctionSignature docNameSignature = new FunctionSignature(new QName("document-name", "http://exist-db.org/xquery/util", "util"), "Returns the name of the document to which the passed node belongs.", new SequenceType[]{new SequenceType(-1, 2)}, new SequenceType(22, 3));
    public static final FunctionSignature docIdSignature = new FunctionSignature(new QName("document-id", "http://exist-db.org/xquery/util", "util"), "Returns the internal id of the document to which the passed node belongs.", new SequenceType[]{new SequenceType(-1, 2)}, new SequenceType(38, 3));

    public DocumentNameOrId(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        NodeValue node = (NodeValue)args[0].itemAt(0);
        if (node.getImplementationType() == 1) {
            NodeProxy proxy = (NodeProxy)node;
            if ("document-name".equals(this.getSignature().getName().getLocalName())) {
                return new StringValue(proxy.getDocument().getFileName());
            }
            return new IntegerValue(proxy.getDocument().getDocId(), 38);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

