/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.text;

import java.util.ArrayList;
import java.util.List;
import org.exist.dom.NodeSet;
import org.exist.storage.analysis.TextToken;
import org.exist.storage.analysis.Tokenizer;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.ExtRegexp;
import org.exist.xquery.value.Sequence;

public abstract class AbstractMatchFunction
extends ExtRegexp {
    public AbstractMatchFunction(XQueryContext context, int type, FunctionSignature signature) {
        super(context, type, signature);
    }

    public abstract Sequence evalQuery(NodeSet var1, List var2) throws XPathException;

    public NodeSet mergeResults(NodeSet[] hits) {
        NodeSet result = hits[0];
        if (result != null) {
            for (int k = 1; k < hits.length; ++k) {
                if (hits[k] == null) continue;
                result = this.type == 1 ? result.deepIntersection(hits[k]) : result.union(hits[k]);
            }
            return result;
        }
        return NodeSet.EMPTY_SET;
    }

    protected List getSearchTerms(XQueryContext context, Sequence contextSequence) throws XPathException {
        TextToken token;
        String searchString = this.getArgument(1).eval(contextSequence).getStringValue();
        ArrayList<String> tokens = new ArrayList<String>();
        Tokenizer tokenizer = context.getBroker().getTextEngine().getTokenizer();
        tokenizer.setText(searchString);
        while (null != (token = tokenizer.nextToken(true))) {
            String word = token.getText();
            tokens.add(word);
        }
        return tokens;
    }
}

