/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunSubstring
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("substring", "http://www.w3.org/2003/05/xpath-functions"), new SequenceType[]{new SequenceType(22, 3), new SequenceType(34, 2)}, new SequenceType(22, 3)), new FunctionSignature(new QName("substring", "http://www.w3.org/2003/05/xpath-functions"), new SequenceType[]{new SequenceType(22, 3), new SequenceType(34, 2), new SequenceType(34, 2)}, new SequenceType(22, 3))};

    public FunSubstring(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public int returnsType() {
        return 22;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq;
        Expression arg0 = this.getArgument(0);
        Expression arg1 = this.getArgument(1);
        Expression arg2 = null;
        if (this.getArgumentCount() > 2) {
            arg2 = this.getArgument(2);
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((seq = arg0.eval(contextSequence)).getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        int start = ((DoubleValue)arg1.eval(contextSequence).itemAt(0).convertTo(34)).getInt();
        if (start <= 0) {
            start = 1;
        }
        int length = 0;
        if (arg2 != null) {
            length = ((NumericValue)arg2.eval(contextSequence).itemAt(0).convertTo(34)).getInt();
        }
        if (start <= 0 || length < 0) {
            throw new IllegalArgumentException("Illegal start or length argument");
        }
        String result = seq.getStringValue();
        if (length > result.length()) {
            length = result.length() - start + 1;
        }
        if (start < 0 || --start + length > result.length()) {
            return new StringValue("");
        }
        return new StringValue(length > 0 ? result.substring(start, start + length) : result.substring(start));
    }
}

