/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AbstractSequence;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class FunSubSequence
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("subsequence", "http://www.w3.org/2003/05/xpath-functions"), "Returns a subsequence of the values in the first argument sequence, starting at the position indicated by the value of the second argument and including the number of items indicated by the value of the optional thirdargument. If the third argument is missing, all items up to the end of the sequence are included.", new SequenceType[]{new SequenceType(11, 7), new SequenceType(34, 2)}, new SequenceType(11, 7)), new FunctionSignature(new QName("subsequence", "http://www.w3.org/2003/05/xpath-functions"), "Returns a subsequence of the values in the first argument sequence, starting at the position indicated by the value of the second argument and including the number of items indicated by the value of the optional thirdargument. If the third argument is missing, all items up to the end of the sequence are included.", new SequenceType[]{new SequenceType(11, 7), new SequenceType(34, 2), new SequenceType(34, 2)}, new SequenceType(11, 7))};

    public FunSubSequence(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq = this.getArgument(0).eval(contextSequence, contextItem);
        if (seq.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        int start = ((DoubleValue)this.getArgument(1).eval(contextSequence, contextItem).convertTo(34)).getInt();
        start = start < 0 ? 0 : --start;
        if (start >= seq.getLength()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        int length = -1;
        if (this.getSignature().getArgumentCount() == 3) {
            length = ((DoubleValue)this.getArgument(2).eval(contextSequence, contextItem).convertTo(34)).getInt();
        }
        if (length < 0 || length > seq.getLength() - start) {
            length = seq.getLength() - start;
        }
        AbstractSequence result = seq instanceof NodeSet ? new ExtArrayNodeSet() : new ValueSequence();
        for (int i = 0; i < length; ++i) {
            result.add(seq.itemAt(start + i));
        }
        return result;
    }
}

