/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunStringPad
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("string-pad", "http://www.w3.org/2003/05/xpath-functions"), "Returns an xs:string consisting of a number copies of the first argument concatenated together without any separators. The number of copies is specified by the second argument.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(31, 2)}, new SequenceType(22, 3));

    public FunStringPad(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq = this.getArgument(0).eval(contextSequence, contextItem);
        if (seq.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String str = seq.getStringValue();
        int count = ((IntegerValue)this.getArgument(1).eval(contextSequence, contextItem).convertTo(31)).getInt();
        if (count == 0) {
            return StringValue.EMPTY_STRING;
        }
        if (count < 0) {
            throw new XPathException("Invalid string-pad count");
        }
        StringBuffer buf = new StringBuffer(str.length() * count);
        for (int i = 0; i < count; ++i) {
            buf.append(str);
        }
        return new StringValue(buf.toString());
    }
}

