/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.exist.dom.QName;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.FunMatches;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunReplace
extends FunMatches {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("replace", "http://www.w3.org/2003/05/xpath-functions"), "The function returns the xs:string that is obtained by replacing all non-overlapping substrings of $a that match the given pattern $b with an occurrence of the $c replacement string.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(22, 3)), new FunctionSignature(new QName("replace", "http://www.w3.org/2003/05/xpath-functions"), "The function returns the xs:string that is obtained by replacing all non-overlapping substrings of $a that match the given pattern $b with an occurrence of the $c replacement string.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(22, 3))};

    public FunReplace(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence stringArg = this.getArgument(0).eval(contextSequence, contextItem);
        if (stringArg.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String string = stringArg.getStringValue();
        String pattern = this.getArgument(1).eval(contextSequence, contextItem).getStringValue();
        String replace = this.getArgument(2).eval(contextSequence, contextItem).getStringValue();
        int flags = 0;
        if (this.getSignature().getArgumentCount() == 4) {
            flags = FunReplace.parseFlags(this.getArgument(3).eval(contextSequence, contextItem).getStringValue());
        }
        try {
            if (this.prevPattern == null || !pattern.equals(this.prevPattern) || flags != this.prevFlags) {
                this.pat = this.compiler.compile(pattern, flags);
            }
            this.prevPattern = pattern;
            this.prevFlags = flags;
            String r = Util.substitute((PatternMatcher)this.matcher, (Pattern)this.pat, (Substitution)new Perl5Substitution(replace), (String)string, (int)-1);
            return new StringValue(r);
        }
        catch (MalformedPatternException e) {
            throw new XPathException("Invalid regular expression: " + e.getMessage(), e);
        }
    }
}

