/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class FunRemove
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("remove", "http://www.w3.org/2003/05/xpath-functions"), "Returns a new sequence constructed from the value of the target sequencewith the item at the position specified removed.", new SequenceType[]{new SequenceType(11, 7), new SequenceType(31, 2)}, new SequenceType(11, 7));

    public FunRemove(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq = this.getArgument(0).eval(contextSequence, contextItem);
        if (seq.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        int pos = ((DoubleValue)this.getArgument(1).eval(contextSequence, contextItem).convertTo(34)).getInt();
        if (pos < 1 || pos > seq.getLength()) {
            return seq;
        }
        --pos;
        if (seq instanceof NodeSet) {
            ExtArrayNodeSet result = new ExtArrayNodeSet();
            result.addAll((NodeSet)seq);
            result.remove((NodeProxy)seq.itemAt(pos));
            return result;
        }
        ValueSequence result = new ValueSequence();
        for (int i = 0; i < seq.getLength(); ++i) {
            if (i == pos) continue;
            result.add(seq.itemAt(i));
        }
        return result;
    }
}

