/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.dom.QNameable;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Node;

public class FunNodeName
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("node-name", "http://www.w3.org/2003/05/xpath-functions", ""), " Returns an expanded-QName for node kinds that can have names. For other kinds of nodes it returns the empty sequence. If $a is the empty sequence, the empty sequence is returned.", new SequenceType[]{new SequenceType(-1, 3)}, new SequenceType(24, 3));

    public FunNodeName(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        NodeSet result;
        Sequence retval = Sequence.EMPTY_SEQUENCE;
        Node n = null;
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((result = this.getArgument(0).eval(contextSequence).toNodeSet()).getLength() > 0) {
            n = result.item(0);
        }
        if (n != null) {
            switch (n.getNodeType()) {
                case 1: 
                case 2: {
                    QName qname = ((QNameable)((Object)n)).getQName();
                    retval = new QNameValue(this.context, ((QNameable)((Object)n)).getQName());
                    break;
                }
                default: {
                    retval = Sequence.EMPTY_SEQUENCE;
                }
            }
        }
        return retval;
    }
}

