/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.exist.dom.QName;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunMatches
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("matches", "http://www.w3.org/2003/05/xpath-functions"), "Returns true if the first argument string matches the regular expression specified by the second argument.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(22, 2)}, new SequenceType(23, 3)), new FunctionSignature(new QName("matches", "http://www.w3.org/2003/05/xpath-functions"), "Returns true if the first argument string matches the regular expression specified by the second argument.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(23, 3))};
    protected Perl5Compiler compiler = new Perl5Compiler();
    protected Perl5Matcher matcher = new Perl5Matcher();
    protected String prevPattern = null;
    protected Pattern pat = null;
    protected int prevFlags = -1;

    public FunMatches(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence stringArg = this.getArgument(0).eval(contextSequence, contextItem);
        if (stringArg.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String string = stringArg.getStringValue();
        String pattern = this.getArgument(1).eval(contextSequence, contextItem).getStringValue();
        int flags = 0;
        if (this.getSignature().getArgumentCount() == 3) {
            flags = FunMatches.parseFlags(this.getArgument(2).eval(contextSequence, contextItem).getStringValue());
        }
        try {
            if (this.prevPattern == null || !pattern.equals(this.prevPattern) || flags != this.prevFlags) {
                this.pat = this.compiler.compile(pattern, flags);
            }
            this.prevPattern = pattern;
            this.prevFlags = flags;
            if (this.matcher.matches(string, this.pat)) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
        catch (MalformedPatternException e) {
            throw new XPathException("Invalid regular expression: " + e.getMessage(), e);
        }
    }

    protected static final int parseFlags(String s) throws XPathException {
        int flags = 0;
        block4: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case 'm': {
                    flags |= 8;
                    continue block4;
                }
                case 'i': {
                    flags |= 1;
                    continue block4;
                }
                default: {
                    throw new XPathException("Invalid regular expression flag: " + ch);
                }
            }
        }
        return flags;
    }
}

