/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.text.Collator;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class FunIndexOf
extends BasicFunction {
    public static final FunctionSignature[] fnIndexOf = new FunctionSignature[]{new FunctionSignature(new QName("index-of", "http://www.w3.org/2003/05/xpath-functions", ""), "Returns a sequence of positive integers giving the positions within the sequence $a of items that are equal to $b. If the value of $a is the empty sequence, or if no item in $a matches $b, then the empty sequence is returned.", new SequenceType[]{new SequenceType(20, 7), new SequenceType(20, 2)}, new SequenceType(31, 3)), new FunctionSignature(new QName("index-of", "http://www.w3.org/2003/05/xpath-functions", ""), "Returns a sequence of positive integers giving the positions within the sequence $a of items that are equal to $b. If the value of $a is the empty sequence, or if no item in $a matches $b, then the empty sequence is returned. Values are compared according to the collation specified in $c.", new SequenceType[]{new SequenceType(20, 7), new SequenceType(20, 2), new SequenceType(22, 2)}, new SequenceType(31, 3))};

    public FunIndexOf(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Collator collator;
        if (args[0].getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        AtomicValue srch = args[1].itemAt(0).atomize();
        if (this.getSignature().getArgumentCount() == 3) {
            String collation = args[2].getStringValue();
            collator = this.context.getCollator(collation);
        } else {
            collator = this.context.getDefaultCollator();
        }
        ValueSequence result = new ValueSequence();
        int j = 1;
        SequenceIterator i = args[0].iterate();
        while (i.hasNext()) {
            AtomicValue next = i.nextItem().atomize();
            if (GeneralComparison.compareAtomic(collator, next, srch, this.context.isBackwardsCompatible(), -1, 4)) {
                result.add(new IntegerValue(j));
            }
            ++j;
        }
        return result;
    }
}

