/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.Iterator;
import java.util.List;
import org.exist.dom.QName;
import org.exist.xquery.Atomize;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class FunConcat
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("concat", "http://www.w3.org/2003/05/xpath-functions"), "Accepts two or more xdt:anyAtomicType arguments and converts them to xs:string. Returns the xs:string that is the concatenation of the values of its arguments after conversion. If any of the arguments is the empty sequence, the argument is treated as the zero-length string.", new SequenceType[]{new SequenceType(20, 3)}, new SequenceType(22, 2), true);

    public FunConcat(XQueryContext context) {
        super(context, signature);
    }

    public int returnsType() {
        return 22;
    }

    public void setArguments(List arguments) throws XPathException {
        Iterator i = arguments.iterator();
        while (i.hasNext()) {
            Expression next = (Expression)i.next();
            if (!Type.subTypeOf(next.returnsType(), 20)) {
                next = new Atomize(this.context, next);
            }
            this.steps.add(next);
        }
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.getArgumentCount() < 2) {
            throw new XPathException("concat requires at least two arguments");
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            result.append(this.getArgument(i).eval(contextSequence).getStringValue());
        }
        return new StringValue(result.toString());
    }
}

