/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunAvg
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("avg", "http://www.w3.org/2003/05/xpath-functions"), "Returns the average of the values in the input sequence $a, that is, the sum of the values divided by the number of values.", new SequenceType[]{new SequenceType(20, 7)}, new SequenceType(20, 3));

    public FunAvg(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence inner = this.getArgument(0).eval(contextSequence, contextItem);
        if (inner.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        SequenceIterator iter = inner.iterate();
        AtomicValue next = (AtomicValue)iter.nextItem();
        if (!Type.subTypeOf(next.getType(), 30)) {
            next = next.convertTo(34);
        }
        ComputableValue sum = (ComputableValue)next;
        while (iter.hasNext()) {
            next = (AtomicValue)iter.nextItem();
            if (!Type.subTypeOf(next.getType(), 30)) {
                next = next.convertTo(34);
            }
            sum = sum.plus((NumericValue)next);
        }
        return sum.div(new IntegerValue(inner.getLength()));
    }
}

