/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.ArrayList;
import java.util.List;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.xquery.CachedResult;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class ExtRegexp
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("match-all", "http://www.w3.org/2003/05/xpath-functions"), "eXist-specific extension function. Tries to match each of the regular expression strings passed in $b and all following parameters against the keywords contained in the fulltext index. The keywords found are then compared to the node set in $a. Every node containing all of the keywords is copied to the result sequence.", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(22, 6)}, new SequenceType(-1, 7), true);
    protected int type = 1;
    protected CachedResult cached = null;

    public ExtRegexp(XQueryContext context) {
        super(context, signature);
    }

    public ExtRegexp(XQueryContext context, int type) {
        super(context, signature);
        this.type = type;
    }

    public ExtRegexp(XQueryContext context, int type, FunctionSignature signature) {
        super(context, signature);
        this.type = type;
    }

    public int getDependencies() {
        int deps = 0;
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            deps |= this.getArgument(i).getDependencies();
        }
        return deps;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Expression path;
        if (this.getArgumentCount() < 2) {
            throw new XPathException(this.getASTNode(), "function requires at least two arguments");
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (((path = this.getArgument(0)).getDependencies() & 2) == 0) {
            boolean canCache;
            boolean bl = canCache = (this.getTermDependencies() & 2) == 0;
            if (canCache && this.cached != null && this.cached.isValid(contextSequence)) {
                return this.cached.getResult();
            }
            NodeSet nodes = path == null ? contextSequence.toNodeSet() : path.eval(contextSequence).toNodeSet();
            List terms = this.getSearchTerms(contextSequence);
            Sequence result = this.evalQuery(nodes, terms);
            if (canCache && contextSequence instanceof NodeSet) {
                this.cached = new CachedResult((NodeSet)contextSequence, result);
            }
            return result;
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        SequenceIterator i = contextSequence.iterate();
        while (i.hasNext()) {
            Item current = i.nextItem();
            List terms = this.getSearchTerms(current.toSequence());
            long start = System.currentTimeMillis();
            NodeSet nodes = path == null ? contextSequence.toNodeSet() : path.eval(current.toSequence()).toNodeSet();
            Sequence temp = this.evalQuery(nodes, terms);
            result.addAll(temp);
            LOG.debug((Object)("found " + temp.getLength() + " in " + (System.currentTimeMillis() - start)));
        }
        return result;
    }

    public Sequence evalQuery(NodeSet nodes, List terms) throws XPathException {
        if (terms == null || terms.size() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        NodeSet[] hits = new NodeSet[terms.size()];
        for (int k = 0; k < terms.size(); ++k) {
            hits[k] = this.context.getBroker().getTextEngine().getNodesContaining(this.context, nodes.getDocumentSet(), nodes, (String)terms.get(k), 1);
        }
        NodeSet result = hits[0];
        if (result != null) {
            for (int k = 1; k < hits.length; ++k) {
                if (hits[k] == null) continue;
                result = this.type == 1 ? result.deepIntersection(hits[k]) : result.union(hits[k]);
            }
            return result;
        }
        return NodeSet.EMPTY_SET;
    }

    protected List getSearchTerms(Sequence contextSequence) throws XPathException {
        if (this.getArgumentCount() < 2) {
            throw new XPathException(this.getASTNode(), "function requires at least 2 arguments");
        }
        ArrayList<String> terms = new ArrayList<String>();
        for (int i = 1; i < this.getLength(); ++i) {
            Expression next = this.getArgument(i);
            Sequence seq = next.eval(contextSequence);
            if (seq.getLength() == 1) {
                terms.add(seq.itemAt(0).getStringValue());
                continue;
            }
            SequenceIterator it = seq.iterate();
            while (it.hasNext()) {
                terms.add(it.nextItem().getStringValue());
            }
        }
        return terms;
    }

    protected int getTermDependencies() throws XPathException {
        int deps = 0;
        for (int i = 1; i < this.getLength(); ++i) {
            Expression next = this.getArgument(i);
            deps |= next.getDependencies();
        }
        return deps;
    }

    public void resetState() {
        super.resetState();
        this.cached = null;
    }
}

