/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.Iterator;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.exist.EXistException;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.storage.NativeTextEngine;
import org.exist.storage.analysis.TextToken;
import org.exist.storage.analysis.Tokenizer;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.ExtFulltext;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;

public class ExtNear
extends ExtFulltext {
    private int max_distance = 1;
    private PatternCompiler globCompiler = new GlobCompiler();
    private Expression distance = null;

    public ExtNear(XQueryContext context) {
        super(context, 1);
    }

    public Sequence evalQuery(String searchArg, NodeSet nodes) throws XPathException {
        if (this.distance != null) {
            this.max_distance = ((IntegerValue)this.distance.eval(nodes).convertTo(31)).getInt();
        }
        try {
            this.getSearchTerms(this.context, searchArg);
        }
        catch (EXistException e) {
            throw new XPathException(e.getMessage(), e);
        }
        NodeSet hits = this.processQuery(nodes);
        if (hits == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        boolean hasWildcards = false;
        for (int i = 0; i < this.terms.length; ++i) {
            hasWildcards |= NativeTextEngine.containsWildcards(this.terms[i]);
        }
        return hasWildcards ? this.patternMatch(this.context, hits) : this.exactMatch(this.context, hits);
    }

    private Sequence exactMatch(XQueryContext context, NodeSet result) {
        ExtArrayNodeSet r = new ExtArrayNodeSet();
        Tokenizer tok = context.getBroker().getTextEngine().getTokenizer();
        Iterator i = result.iterator();
        block0: while (i.hasNext()) {
            TextToken token;
            NodeProxy current = (NodeProxy)i.next();
            String value = current.getNodeValue();
            tok.setText(value);
            int j = 0;
            if (j >= this.terms.length) break;
            String term = this.terms[j];
            int distance = -1;
            while ((token = tok.nextToken()) != null) {
                String word = token.getText().toLowerCase();
                if (distance > this.max_distance) {
                    j = 0;
                    term = this.terms[j];
                    distance = -1;
                }
                if (word.equalsIgnoreCase(term)) {
                    distance = 0;
                    if (++j == this.terms.length) {
                        r.add(current);
                        continue block0;
                    }
                    term = this.terms[j];
                } else if (j > 0 && word.equalsIgnoreCase(this.terms[0])) {
                    j = 1;
                    term = this.terms[j];
                    distance = 0;
                    continue;
                }
                if (-1 >= distance) continue;
                ++distance;
            }
        }
        return r;
    }

    private Sequence patternMatch(XQueryContext context, NodeSet result) {
        Pattern[] patterns = new Pattern[this.terms.length];
        for (int i = 0; i < patterns.length; ++i) {
            try {
                patterns[i] = this.globCompiler.compile(this.terms[i], 5);
                continue;
            }
            catch (MalformedPatternException e) {
                LOG.warn((Object)"malformed pattern", (Throwable)e);
                return Sequence.EMPTY_SEQUENCE;
            }
        }
        ExtArrayNodeSet r = new ExtArrayNodeSet(100);
        Perl5Matcher matcher = new Perl5Matcher();
        Tokenizer tok = context.getBroker().getTextEngine().getTokenizer();
        Iterator i = result.iterator();
        block3: while (i.hasNext()) {
            TextToken token;
            NodeProxy current = (NodeProxy)i.next();
            String value = current.getNodeValue();
            tok.setText(value);
            int j = 0;
            if (j >= patterns.length) break;
            Pattern term = patterns[j];
            int distance = -1;
            while ((token = tok.nextToken()) != null) {
                String word = token.getText().toLowerCase();
                if (distance > this.max_distance) {
                    j = 0;
                    term = patterns[j];
                    distance = -1;
                    continue;
                }
                if (matcher.matches(word, term)) {
                    distance = 0;
                    if (++j == patterns.length) {
                        r.add(current);
                        continue block3;
                    }
                    term = patterns[j];
                    continue;
                }
                if (j > 0 && matcher.matches(word, patterns[0])) {
                    j = 1;
                    term = patterns[j];
                    distance = 0;
                    continue;
                }
                if (-1 >= distance) continue;
                ++distance;
            }
        }
        return r;
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append("near(");
        buf.append(this.path.pprint());
        buf.append(", ");
        buf.append(this.searchTerm.pprint());
        buf.append(')');
        return buf.toString();
    }

    public void setDistance(Expression expr) {
        this.distance = expr;
    }
}

