/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.util.Lock;
import org.exist.util.LockException;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class ExtCollection
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("collection", "http://www.w3.org/2003/05/xpath-functions"), "Includes the documents contained in the specified collection into the input sequence. eXist interprets the arguments as absolute paths pointing to database collections, as for example, '/db/test'. Documents located in subcollections of a collection are included into the input set.", new SequenceType[]{new SequenceType(22, 6)}, new SequenceType(-1, 7), true);
    private boolean includeSubCollections = false;
    private List cachedArgs = null;
    private Sequence cached = null;

    public ExtCollection(XQueryContext context) {
        this(context, signature, true);
    }

    public ExtCollection(XQueryContext context, FunctionSignature signature, boolean inclusive) {
        super(context, signature);
        this.includeSubCollections = inclusive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        List args = this.getParameterValues(contextSequence, contextItem);
        boolean cacheIsValid = false;
        if (this.cachedArgs != null) {
            cacheIsValid = this.compareArguments(this.cachedArgs, args);
        }
        if (cacheIsValid) {
            return this.cached;
        }
        DocumentSet docs = new DocumentSet();
        for (int i = 0; i < args.size(); ++i) {
            String next = (String)args.get(i);
            Collection coll = this.context.getBroker().getCollection(next);
            if (coll == null) continue;
            coll.allDocs(this.context.getBroker(), docs, this.includeSubCollections, true);
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet(docs.getLength(), 1);
        Iterator i = docs.iterator();
        while (i.hasNext()) {
            DocumentImpl doc = (DocumentImpl)i.next();
            Lock dlock = doc.getUpdateLock();
            try {
                dlock.acquire(0);
                result.add(new NodeProxy(doc, -1L, 9));
            }
            catch (LockException e) {
                LOG.info((Object)("Could not acquire read lock on document " + doc.getFileName()));
            }
            finally {
                dlock.release(0);
            }
        }
        this.cached = result;
        this.cachedArgs = args;
        return result;
    }

    private List getParameterValues(Sequence contextSequence, Item contextItem) throws XPathException {
        ArrayList<String> args = new ArrayList<String>(this.getArgumentCount() + 10);
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            Sequence seq = this.getArgument(i).eval(contextSequence, contextItem);
            SequenceIterator j = seq.iterate();
            while (j.hasNext()) {
                Item next = j.nextItem();
                args.add(next.getStringValue());
            }
        }
        return args;
    }

    private boolean compareArguments(List args1, List args2) {
        if (args1.size() != args2.size()) {
            return false;
        }
        for (int i = 0; i < args1.size(); ++i) {
            String arg2;
            String arg1 = (String)args1.get(i);
            if (arg1.equals(arg2 = (String)args2.get(i))) continue;
            return false;
        }
        return true;
    }

    public void resetState() {
        this.cached = null;
        this.cachedArgs = null;
    }
}

