/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.dom.SymbolTable;
import org.exist.memtree.MemTreeBuilder;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.source.AbstractSource;
import org.exist.source.FileSource;
import org.exist.source.URLSource;
import org.exist.storage.DBBroker;
import org.exist.util.Collations;
import org.exist.util.LockException;
import org.exist.xquery.Expression;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.Module;
import org.exist.xquery.ModuleContext;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Pragma;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryWatchDog;
import org.exist.xquery.parser.XQueryLexer;
import org.exist.xquery.parser.XQueryParser;
import org.exist.xquery.parser.XQueryTreeParser;
import org.exist.xquery.value.Sequence;

public class XQueryContext {
    public static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    public static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    public static final String SCHEMA_DATATYPES_NS = "http://www.w3.org/2001/XMLSchema-datatypes";
    public static final String SCHEMA_INSTANCE_NS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XPATH_DATATYPES_NS = "http://www.w3.org/2003/05/xpath-datatypes";
    public static final String XQUERY_LOCAL_NS = "http://www.w3.org/2003/08/xquery-local-functions";
    public static final String EXIST_NS = "http://exist.sourceforge.net/NS/exist";
    private static final Logger LOG = Logger.getLogger((Class)XQueryContext.class);
    private static final String TEMP_STORE_ERROR = "Error occurred while storing temporary data";
    protected HashMap namespaces;
    protected HashMap inScopeNamespaces = new HashMap();
    protected HashMap prefixes;
    protected HashMap inScopePrefixes = new HashMap();
    protected Stack namespaceStack = new Stack();
    protected TreeMap declaredFunctions = new TreeMap();
    protected TreeMap globalVariables = new TreeMap();
    protected LocalVariable lastVar = null;
    protected int variableStackSize = 0;
    protected Stack forwardReferences = new Stack();
    protected List pragmas = null;
    protected XQueryWatchDog watchdog;
    protected HashMap modules = new HashMap();
    protected String[] staticDocumentPaths = null;
    protected DocumentSet staticDocuments = null;
    protected DBBroker broker;
    protected String baseURI = "";
    protected String moduleLoadPath = ".";
    protected String defaultFunctionNamespace = "http://www.w3.org/2003/05/xpath-functions";
    private String defaultCollation = "http://www.w3.org/2004/07/xpath-functions/collation/codepoint";
    private Collator defaultCollator = null;
    private boolean backwardsCompatible = true;
    private boolean stripWhitespace = true;
    private int contextPosition = 0;
    private MemTreeBuilder builder = null;
    private Stack fragmentStack = new Stack();
    private Expression rootExpression;
    private boolean exclusive = false;

    protected XQueryContext() {
        this.builder = new MemTreeBuilder(this);
        this.builder.startDocument();
    }

    public XQueryContext(DBBroker broker) {
        this();
        this.broker = broker;
        this.loadDefaults();
    }

    public void setRootExpression(Expression expr) {
        this.rootExpression = expr;
    }

    public Expression getRootExpression() {
        return this.rootExpression;
    }

    public void declareNamespace(String prefix, String uri) {
        String prevURI;
        if (prefix == null) {
            prefix = "";
        }
        if (uri == null) {
            uri = "";
        }
        if ((prevURI = (String)this.namespaces.get(prefix)) != null) {
            this.prefixes.remove(prevURI);
        }
        this.namespaces.put(prefix, uri);
        this.prefixes.put(uri, prefix);
    }

    public void declareNamespaces(Map namespaceMap) {
        Iterator i = namespaceMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            if (prefix == null) {
                prefix = "";
            }
            if (uri == null) {
                uri = "";
            }
            this.namespaces.put(prefix, uri);
            this.prefixes.put(uri, prefix);
        }
    }

    public void declareInScopeNamespace(String prefix, String uri) {
        if (prefix == null || uri == null) {
            throw new IllegalArgumentException("null argument passed to declareNamespace");
        }
        if (this.inScopeNamespaces == null) {
            this.inScopeNamespaces = new HashMap();
        }
        this.inScopeNamespaces.put(prefix, uri);
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setDefaultFunctionNamespace(String uri) {
        this.defaultFunctionNamespace = uri;
    }

    public void setDefaultCollation(String uri) throws XPathException {
        if (uri.equals("http://www.w3.org/2004/07/xpath-functions/collation/codepoint") || uri.equals("codepoint")) {
            this.defaultCollation = "http://www.w3.org/2004/07/xpath-functions/collation/codepoint";
            this.defaultCollator = null;
        }
        this.defaultCollator = Collations.getCollationFromURI(this, uri);
        this.defaultCollation = uri;
    }

    public String getDefaultCollation() {
        return this.defaultCollation;
    }

    public Collator getCollator(String uri) throws XPathException {
        if (uri == null) {
            return this.defaultCollator;
        }
        return Collations.getCollationFromURI(this, uri);
    }

    public Collator getDefaultCollator() {
        return this.defaultCollator;
    }

    public String getURIForPrefix(String prefix) {
        String ns = (String)this.namespaces.get(prefix);
        if (ns == null) {
            return this.inScopeNamespaces == null ? null : (String)this.inScopeNamespaces.get(prefix);
        }
        return ns;
    }

    public String getPrefixForURI(String uri) {
        String prefix = (String)this.prefixes.get(uri);
        if (prefix == null) {
            return this.inScopePrefixes == null ? null : (String)this.inScopeNamespaces.get(uri);
        }
        return prefix;
    }

    public void removeNamespace(String uri) {
        this.prefixes.remove(uri);
        Iterator i = this.namespaces.values().iterator();
        while (i.hasNext()) {
            if (!((String)i.next()).equals(uri)) continue;
            i.remove();
            return;
        }
        this.inScopePrefixes.remove(uri);
        if (this.inScopeNamespaces != null) {
            i = this.inScopeNamespaces.values().iterator();
            while (i.hasNext()) {
                if (!((String)i.next()).equals(uri)) continue;
                i.remove();
                return;
            }
        }
    }

    public void clearNamespaces() {
        this.namespaces.clear();
        this.prefixes.clear();
        if (this.inScopeNamespaces != null) {
            this.inScopeNamespaces.clear();
            this.inScopePrefixes.clear();
        }
        this.loadDefaults();
    }

    public void setStaticallyKnownDocuments(String[] docs) {
        this.staticDocumentPaths = docs;
    }

    public void setStaticallyKnownDocuments(DocumentSet set) {
        this.staticDocuments = set;
    }

    public DocumentSet getStaticallyKnownDocuments() throws XPathException {
        if (this.staticDocuments != null) {
            return this.staticDocuments;
        }
        this.staticDocuments = new DocumentSet();
        if (this.staticDocumentPaths == null) {
            this.broker.getAllDocuments(this.staticDocuments);
        } else {
            for (int i = 0; i < this.staticDocumentPaths.length; ++i) {
                try {
                    DocumentImpl doc = this.broker.openDocument(this.staticDocumentPaths[i], 0);
                    if (doc != null) {
                        if (doc.getPermissions().validate(this.broker.getUser(), 4)) {
                            this.staticDocuments.add(doc);
                        }
                        doc.getUpdateLock().release(0);
                        continue;
                    }
                    Collection collection = this.broker.getCollection(this.staticDocumentPaths[i]);
                    if (collection == null) continue;
                    LOG.debug((Object)("reading collection " + this.staticDocumentPaths[i]));
                    collection.allDocs(this.broker, this.staticDocuments, true, true);
                    continue;
                }
                catch (PermissionDeniedException e) {
                    LOG.warn((Object)("Permission denied to read resource " + this.staticDocumentPaths[i] + ". Skipping it."));
                }
            }
        }
        return this.staticDocuments;
    }

    public void reset() {
        this.builder = new MemTreeBuilder(this);
        this.builder.startDocument();
        this.staticDocumentPaths = null;
        this.staticDocuments = null;
        this.lastVar = null;
        this.fragmentStack = new Stack();
        this.watchdog.reset();
    }

    public boolean stripWhitespace() {
        return this.stripWhitespace;
    }

    public void setStripWhitespace(boolean strip) {
        this.stripWhitespace = strip;
    }

    public Iterator getModules() {
        return this.modules.values().iterator();
    }

    public Module getModule(String namespaceURI) {
        return (Module)this.modules.get(namespaceURI);
    }

    public boolean checkModulesValid() {
        Iterator i = this.modules.values().iterator();
        while (i.hasNext()) {
            Module module = (Module)i.next();
            if (module.isInternalModule() || ((ExternalModule)module).moduleIsValid()) continue;
            LOG.debug((Object)("Module with URI " + module.getNamespaceURI() + " has changed and needs to be reloaded"));
            return false;
        }
        return true;
    }

    public Module loadBuiltInModule(String namespaceURI, String moduleClass) {
        Module module = this.getModule(namespaceURI);
        if (module != null) {
            return module;
        }
        try {
            Class<?> mClass = Class.forName(moduleClass);
            if (!Module.class.isAssignableFrom(mClass)) {
                LOG.warn((Object)("failed to load module. " + moduleClass + " is not an instance of org.exist.xquery.Module."));
                return null;
            }
            module = (Module)mClass.newInstance();
            if (!module.getNamespaceURI().equals(namespaceURI)) {
                LOG.warn((Object)"the module declares a different namespace URI. Skipping...");
                return null;
            }
            if (this.getPrefixForURI(module.getNamespaceURI()) == null && module.getDefaultPrefix().length() > 0) {
                this.declareNamespace(module.getDefaultPrefix(), module.getNamespaceURI());
            }
            this.modules.put(module.getNamespaceURI(), module);
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
            LOG.warn((Object)("error while instantiating module class " + moduleClass), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)("error while instantiating module class " + moduleClass), (Throwable)e);
        }
        return module;
    }

    public void declareFunction(UserDefinedFunction function) throws XPathException {
        this.declaredFunctions.put(function.getName(), function);
    }

    public UserDefinedFunction resolveFunction(QName name) throws XPathException {
        UserDefinedFunction func = (UserDefinedFunction)this.declaredFunctions.get(name);
        return func;
    }

    public Iterator localFunctions() {
        return this.declaredFunctions.values().iterator();
    }

    public LocalVariable declareVariable(LocalVariable var) throws XPathException {
        if (this.lastVar == null) {
            this.lastVar = var;
        } else {
            this.lastVar.addAfter(var);
            this.lastVar = var;
        }
        var.setStackPosition(this.variableStackSize);
        return var;
    }

    public Variable declareGlobalVariable(Variable var) throws XPathException {
        this.globalVariables.put(var.getQName(), var);
        var.setStackPosition(this.variableStackSize);
        return var;
    }

    public Variable declareVariable(String qname, Object value) throws XPathException {
        QName qn = QName.parse(this, qname, null);
        Module module = this.getModule(qn.getNamespaceURI());
        if (module != null) {
            Variable var = module.declareVariable(qn, value);
            return var;
        }
        Sequence val = XPathUtil.javaObjectToXPath(value);
        Variable var = (Variable)this.globalVariables.get(qn);
        if (var == null) {
            var = new Variable(qn);
            this.globalVariables.put(qn, var);
        }
        var.setValue(val);
        return var;
    }

    public Variable resolveVariable(String name) throws XPathException {
        QName qn = QName.parse(this, name, null);
        return this.resolveVariable(qn);
    }

    public Variable resolveVariable(QName qname) throws XPathException {
        Variable var;
        Module module = this.getModule(qname.getNamespaceURI());
        if (module != null && (var = module.resolveVariable(qname)) != null) {
            return var;
        }
        var = this.resolveLocalVariable(qname);
        if (var == null) {
            var = (Variable)this.globalVariables.get(qname);
        }
        if (var == null) {
            throw new XPathException("variable " + qname + " is not bound");
        }
        return var;
    }

    private Variable resolveLocalVariable(QName qname) throws XPathException {
        LocalVariable var = this.lastVar;
        while (var != null) {
            if (qname.equals(var.getQName())) {
                return var;
            }
            var = var.before;
        }
        return null;
    }

    public void setBackwardsCompatibility(boolean backwardsCompatible) {
        this.backwardsCompatible = backwardsCompatible;
    }

    public boolean isBackwardsCompatible() {
        return this.backwardsCompatible;
    }

    public DBBroker getBroker() {
        return this.broker;
    }

    public void setBroker(DBBroker broker) {
        this.broker = broker;
    }

    public User getUser() {
        return this.broker.getUser();
    }

    public MemTreeBuilder getDocumentBuilder() {
        if (this.builder == null) {
            this.builder = new MemTreeBuilder(this);
            this.builder.startDocument();
        }
        return this.builder;
    }

    public void proceed() throws TerminatedException {
        this.proceed(null);
    }

    public void proceed(Expression expr) throws TerminatedException {
        this.watchdog.proceed(expr);
    }

    public void proceed(Expression expr, MemTreeBuilder builder) throws TerminatedException {
        this.watchdog.proceed(expr, builder);
    }

    public void recover() {
        this.watchdog.reset();
        this.builder = null;
    }

    public XQueryWatchDog getWatchDog() {
        return this.watchdog;
    }

    protected void setWatchDog(XQueryWatchDog watchdog) {
        this.watchdog = watchdog;
    }

    public void pushDocumentContext() {
        this.fragmentStack.push(this.builder);
        this.builder = null;
    }

    public void popDocumentContext() {
        if (!this.fragmentStack.isEmpty()) {
            this.builder = (MemTreeBuilder)this.fragmentStack.pop();
        }
    }

    public void setBaseURI(String uri) {
        this.baseURI = uri;
    }

    public void setModuleLoadPath(String path) {
        this.moduleLoadPath = path;
    }

    public String getModuleLoadPath() {
        return this.moduleLoadPath;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setContextPosition(int pos) {
        this.contextPosition = pos;
    }

    public int getContextPosition() {
        return this.contextPosition;
    }

    public void pushInScopeNamespaces() {
        HashMap m = (HashMap)this.inScopeNamespaces.clone();
        this.namespaceStack.push(this.inScopeNamespaces);
        this.inScopeNamespaces = m;
    }

    public void popInScopeNamespaces() {
        this.inScopeNamespaces = (HashMap)this.namespaceStack.pop();
    }

    public void pushNamespaceContext() {
        HashMap m = (HashMap)this.namespaces.clone();
        HashMap p = (HashMap)this.prefixes.clone();
        this.namespaceStack.push(this.namespaces);
        this.namespaceStack.push(this.prefixes);
        this.namespaces = m;
        this.prefixes = p;
    }

    public void popNamespaceContext() {
        this.prefixes = (HashMap)this.namespaceStack.pop();
        this.namespaces = (HashMap)this.namespaceStack.pop();
    }

    public LocalVariable markLocalVariables() {
        ++this.variableStackSize;
        return this.lastVar;
    }

    public void popLocalVariables(LocalVariable var) {
        if (var != null) {
            var.after = null;
        }
        this.lastVar = var;
        --this.variableStackSize;
    }

    public int getCurrentStackSize() {
        return this.variableStackSize;
    }

    public void importModule(String namespaceURI, String prefix, String location) throws XPathException {
        Module module = this.getModule(namespaceURI);
        if (module != null) {
            LOG.debug((Object)("Module " + namespaceURI + " already present."));
        } else {
            if (location == null) {
                location = namespaceURI;
            }
            if (location.startsWith("java:")) {
                location = location.substring("java:".length());
                module = this.loadBuiltInModule(namespaceURI, location);
            } else {
                Reader reader;
                AbstractSource source = null;
                if (location.indexOf(58) < 0) {
                    File f = new File(this.moduleLoadPath + File.separatorChar + location);
                    if (!f.canRead() && !(f = new File(location)).canRead()) {
                        throw new XPathException("cannot read module source from file at " + f.getAbsolutePath());
                    }
                    location = f.toURI().toASCIIString();
                    source = new FileSource(f, "UTF-8");
                } else {
                    URL url;
                    try {
                        url = new URL(location);
                    }
                    catch (MalformedURLException e1) {
                        throw new XPathException("source location for module " + namespaceURI + " should be a valid URL");
                    }
                    source = new URLSource(url);
                }
                LOG.debug((Object)("Loading module from " + location));
                try {
                    reader = source.getReader();
                }
                catch (IOException e) {
                    throw new XPathException("IO exception while loading module " + namespaceURI, e);
                }
                ModuleContext context = new ModuleContext(this);
                XQueryLexer lexer = new XQueryLexer(context, reader);
                XQueryParser parser = new XQueryParser(lexer);
                XQueryTreeParser astParser = new XQueryTreeParser(context);
                try {
                    parser.xpath();
                    if (parser.foundErrors()) {
                        LOG.debug((Object)parser.getErrorMessage());
                        throw new XPathException("error found while loading module from " + location + ": " + parser.getErrorMessage());
                    }
                    AST ast = parser.getAST();
                    PathExpr path = new PathExpr(context);
                    astParser.xpath(ast, path);
                    if (astParser.foundErrors()) {
                        throw new XPathException("error found while loading module from " + location + ": " + astParser.getErrorMessage(), astParser.getLastException());
                    }
                    ExternalModule modExternal = astParser.getModule();
                    if (modExternal == null) {
                        throw new XPathException("source at " + location + " is not a valid module");
                    }
                    if (!modExternal.getNamespaceURI().equals(namespaceURI)) {
                        throw new XPathException("namespace URI declared by module (" + modExternal.getNamespaceURI() + ") does not match namespace URI in import statement, which was: " + namespaceURI);
                    }
                    this.modules.put(modExternal.getNamespaceURI(), modExternal);
                    modExternal.setSource(source);
                    modExternal.setContext(context);
                    module = modExternal;
                }
                catch (RecognitionException e) {
                    throw new XPathException("error found while loading module from " + location + ": " + e.getMessage(), e.getLine(), e.getColumn());
                }
                catch (TokenStreamException e) {
                    throw new XPathException("error found while loading module from " + location + ": " + e.getMessage(), e);
                }
            }
        }
        if (prefix == null) {
            prefix = module.getDefaultPrefix();
        }
        this.declareNamespace(prefix, namespaceURI);
    }

    public void addForwardReference(FunctionCall call) {
        this.forwardReferences.push(call);
    }

    public void resolveForwardReferences() throws XPathException {
        while (!this.forwardReferences.empty()) {
            FunctionCall call = (FunctionCall)this.forwardReferences.pop();
            UserDefinedFunction func = this.resolveFunction(call.getQName());
            if (func == null) {
                throw new XPathException(call.getASTNode(), "Call to undeclared function: " + call.getQName().toString());
            }
            call.resolveForwardReference(func);
        }
    }

    public void setExclusiveMode(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public boolean inExclusiveMode() {
        return this.exclusive;
    }

    public void addPragma(String qnameString, String contents) throws XPathException {
        QName qn;
        try {
            qn = QName.parse(this, qnameString, this.defaultFunctionNamespace);
        }
        catch (XPathException e) {
            LOG.debug((Object)("Ignoring unknown pragma: " + qnameString));
            return;
        }
        Pragma pragma = new Pragma(qn, contents);
        if (this.pragmas == null) {
            this.pragmas = new ArrayList();
        }
        this.pragmas.add(pragma);
        if (Pragma.TIMEOUT_QNAME.compareTo(qn) == 0) {
            this.watchdog.setTimeoutFromPragma(pragma);
        }
        if (Pragma.OUTPUT_SIZE_QNAME.compareTo(qn) == 0) {
            this.watchdog.setMaxNodesFromPragma(pragma);
        }
    }

    public Pragma getPragma(QName qname) {
        if (this.pragmas != null) {
            for (int i = 0; i < this.pragmas.size(); ++i) {
                Pragma pragma = (Pragma)this.pragmas.get(i);
                if (qname.compareTo(pragma.getQName()) != 0) continue;
                return pragma;
            }
        }
        return null;
    }

    public NodeSet storeTemporaryDoc(String data) throws XPathException {
        try {
            DocumentImpl doc = this.broker.storeTemporaryDoc(data);
            this.watchdog.addTemporaryFragment(doc.getFileName());
            return new NodeProxy(doc, 1L, doc.getFirstChildAddress());
        }
        catch (EXistException e) {
            throw new XPathException(TEMP_STORE_ERROR, e);
        }
        catch (PermissionDeniedException e) {
            throw new XPathException(TEMP_STORE_ERROR, e);
        }
        catch (LockException e) {
            throw new XPathException(TEMP_STORE_ERROR, e);
        }
    }

    protected void loadDefaults() {
        this.watchdog = new XQueryWatchDog(this);
        SymbolTable syms = this.broker.getSymbols();
        String[] pfx = syms.defaultPrefixList();
        this.namespaces = new HashMap(pfx.length);
        this.prefixes = new HashMap(pfx.length);
        for (int i = 0; i < pfx.length; ++i) {
            String sym = syms.getDefaultNamespace(pfx[i]);
            this.namespaces.put(pfx[i], sym);
            this.prefixes.put(sym, pfx[i]);
        }
        this.declareNamespace("xml", XML_NS);
        this.declareNamespace("xs", SCHEMA_NS);
        this.declareNamespace("xdt", XPATH_DATATYPES_NS);
        this.declareNamespace("local", XQUERY_LOCAL_NS);
        this.declareNamespace("fn", "http://www.w3.org/2003/05/xpath-functions");
        this.declareNamespace("exist", EXIST_NS);
        this.loadBuiltInModule("http://www.w3.org/2003/05/xpath-functions", "org.exist.xquery.functions.ModuleImpl");
        this.loadBuiltInModule("http://exist-db.org/xquery/util", "org.exist.xquery.functions.util.UtilModule");
        this.loadBuiltInModule("http://exist-db.org/xquery/transform", "org.exist.xquery.functions.transform.TransformModule");
        this.loadBuiltInModule("http://exist-db.org/xquery/xmldb", "org.exist.xquery.functions.xmldb.XMLDBModule");
        this.loadBuiltInModule("http://exist-db.org/xquery/request", "org.exist.xquery.functions.request.RequestModule");
        this.loadBuiltInModule("http://exist-db.org/xquery/text", "org.exist.xquery.functions.text.TextModule");
    }
}

