/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.IOException;
import java.io.Reader;
import org.apache.log4j.Logger;
import org.exist.source.Source;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryLexer;
import org.exist.xquery.parser.XQueryParser;
import org.exist.xquery.parser.XQueryTreeParser;
import org.exist.xquery.value.Sequence;

public class XQuery {
    private static final Logger LOG = Logger.getLogger((Class)XQuery.class);
    private DBBroker broker;

    public XQuery(DBBroker broker) {
        this.broker = broker;
    }

    public XQueryContext newContext() {
        return new XQueryContext(this.broker);
    }

    public XQueryPool getXQueryPool() {
        return this.broker.getBrokerPool().getXQueryPool();
    }

    public CompiledXQuery compile(XQueryContext context, Source source) throws XPathException, IOException {
        Reader reader = source.getReader();
        return this.compile(context, reader);
    }

    public CompiledXQuery compile(XQueryContext context, Reader reader) throws XPathException {
        long start = System.currentTimeMillis();
        XQueryLexer lexer = new XQueryLexer(context, reader);
        XQueryParser parser = new XQueryParser(lexer);
        XQueryTreeParser treeParser = new XQueryTreeParser(context);
        try {
            parser.xpath();
            if (parser.foundErrors()) {
                LOG.debug((Object)parser.getErrorMessage());
                throw new XPathException(parser.getErrorMessage());
            }
            AST ast = parser.getAST();
            PathExpr expr = new PathExpr(context);
            treeParser.xpath(ast, expr);
            if (treeParser.foundErrors()) {
                throw new XPathException(treeParser.getErrorMessage(), treeParser.getLastException());
            }
            LOG.debug((Object)("Query:\n" + expr.pprint() + "\nCompilation took " + (System.currentTimeMillis() - start)));
            return expr;
        }
        catch (RecognitionException e) {
            throw new XPathException(e.getMessage(), e.getLine(), e.getColumn());
        }
        catch (TokenStreamException e) {
            throw new XPathException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence execute(CompiledXQuery expression, Sequence contextSequence) throws XPathException {
        XQueryContext context = expression.getContext();
        context.setBroker(this.broker);
        expression.reset();
        context.getWatchDog().reset();
        this.broker.getBrokerPool().getXQueryMonitor().queryStarted(context.getWatchDog());
        try {
            Sequence result = expression.eval(contextSequence);
            expression.reset();
            context.reset();
            Sequence sequence = result;
            Object var7_6 = null;
            this.broker.getBrokerPool().getXQueryMonitor().queryCompleted(context.getWatchDog());
            return sequence;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.broker.getBrokerPool().getXQueryMonitor().queryCompleted(context.getWatchDog());
            throw throwable;
        }
    }
}

