/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.QName;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.Expression;
import org.exist.xquery.Module;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class VariableDeclaration
extends AbstractExpression {
    String qname;
    SequenceType sequenceType = null;
    Expression expression;

    public VariableDeclaration(XQueryContext context, String qname, Expression expr) {
        super(context);
        this.qname = qname;
        this.expression = expr;
    }

    public void setSequenceType(SequenceType type) {
        this.sequenceType = type;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        QName qn = QName.parse(this.context, this.qname, null);
        Module myModule = this.context.getModule(qn.getNamespaceURI());
        Sequence seq = this.expression.eval(contextSequence, contextItem);
        if (this.sequenceType != null) {
            this.sequenceType.checkType(seq.getItemType());
            this.sequenceType.checkCardinality(seq);
        }
        if (myModule != null) {
            myModule.declareVariable(qn, seq);
        } else {
            Variable var = new Variable(qn);
            var.setValue(seq);
            this.context.declareGlobalVariable(var);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    public String pprint() {
        return "";
    }

    public int returnsType() {
        return this.expression.returnsType();
    }

    public int getDependencies() {
        return this.expression.getDependencies();
    }

    public int getCardinality() {
        return this.expression.getCardinality();
    }

    public void resetState() {
        this.expression.resetState();
    }
}

