/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.dom.QName;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class UserDefinedFunction
extends Function {
    private Expression body;
    private List parameters = new ArrayList(5);
    private Sequence[] currentArguments = null;
    private boolean isReset = false;

    public UserDefinedFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public void setFunctionBody(Expression body) {
        this.body = body;
    }

    public void addVariable(String varName) throws XPathException {
        QName qname = QName.parse(this.context, varName, null);
        this.parameters.add(qname);
    }

    public void setArguments(Sequence[] args) throws XPathException {
        this.currentArguments = args;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        int j = 0;
        Iterator i = this.parameters.iterator();
        while (i.hasNext()) {
            QName varName = (QName)i.next();
            LocalVariable var = new LocalVariable(varName);
            var.setValue(this.currentArguments[j]);
            this.context.declareVariable(var);
            ++j;
        }
        Sequence result = this.body.eval(contextSequence, contextItem);
        return result;
    }

    public String pprint() {
        FunctionSignature signature = this.getSignature();
        StringBuffer buf = new StringBuffer();
        buf.append("declare function ");
        buf.append(this.toString());
        return buf.toString();
    }

    public String toString() {
        FunctionSignature signature = this.getSignature();
        StringBuffer buf = new StringBuffer();
        buf.append(signature.getName());
        buf.append('(');
        for (int i = 0; i < signature.getArgumentTypes().length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(signature.getArgumentTypes()[i]);
        }
        buf.append(')');
        return buf.toString();
    }

    public int getDependencies() {
        return 19;
    }

    public void resetState() {
        if (!this.isReset) {
            this.isReset = true;
            this.body.resetState();
            this.isReset = false;
        }
    }
}

