/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.apache.log4j.Logger;
import org.exist.dom.NodeSet;
import org.exist.xquery.CombiningExpression;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class Union
extends CombiningExpression {
    private static final Logger LOG = Logger.getLogger((Class)Union.class);

    public Union(XQueryContext context, PathExpr left, PathExpr right) {
        super(context, left, right);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence lval = this.left.eval(contextSequence, contextItem);
        Sequence rval = this.right.eval(contextSequence, contextItem);
        long start = System.currentTimeMillis();
        if (lval.getLength() == 0) {
            return rval;
        }
        if (rval.getLength() == 0) {
            return lval;
        }
        if (!Type.subTypeOf(lval.getItemType(), -1) || !Type.subTypeOf(rval.getItemType(), -1)) {
            throw new XPathException("union operand is not a node sequence");
        }
        NodeSet result = lval.toNodeSet().union(rval.toNodeSet());
        return result;
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.left.pprint());
        buf.append(" union ");
        buf.append(this.right.pprint());
        return buf.toString();
    }
}

