/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.StringTokenizer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.exist.dom.QName;

public class Pragma {
    public static final QName TIMEOUT_QNAME = new QName("timeout", "http://exist.sourceforge.net/NS/exist");
    public static final QName OUTPUT_SIZE_QNAME = new QName("output-size-limit", "http://exist.sourceforge.net/NS/exist");
    public static final QName SERIALIZE_QNAME = new QName("serialize", "http://exist.sourceforge.net/NS/exist");
    private static final String paramPattern = "\\s*([\\w\\.-]+)\\s*=\\s*('[^']*'|\"[^\"]*\"|[^\\s]+)";
    private static Perl5Matcher matcher = new Perl5Matcher();
    private static Pattern pattern;
    private QName qname;
    private String contents;

    public Pragma(QName qname, String contents) {
        this.qname = qname;
        this.contents = contents;
    }

    public QName getQName() {
        return this.qname;
    }

    public String getContents() {
        return this.contents;
    }

    public String[] tokenizeContents() {
        if (this.contents == null) {
            return new String[0];
        }
        StringTokenizer tok = new StringTokenizer(this.contents, " \r\t\n");
        String[] items = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            items[i] = tok.nextToken();
            ++i;
        }
        return items;
    }

    public static synchronized String[] parseKeyValuePair(String s) {
        if (matcher.matches(s, pattern)) {
            MatchResult result = matcher.getMatch();
            String value = result.group(2);
            if (value.charAt(0) == '\'' || value.charAt(0) == '\"') {
                value = value.substring(1, value.length() - 1);
            }
            return new String[]{result.group(1), value};
        }
        return null;
    }

    static {
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            pattern = compiler.compile(paramPattern);
        }
        catch (MalformedPatternException e) {
            throw new RuntimeException(e);
        }
    }
}

