/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.exist.dom.DocumentSet;
import org.exist.xmldb.CompiledExpression;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.Expression;
import org.exist.xquery.LiteralValue;
import org.exist.xquery.Predicate;
import org.exist.xquery.Step;
import org.exist.xquery.Variable;
import org.exist.xquery.VariableReference;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.ValueSequence;

public class PathExpr
extends AbstractExpression
implements CompiledXQuery,
CompiledExpression {
    protected static final Logger LOG = Logger.getLogger((Class)PathExpr.class);
    protected boolean keepVirtual = false;
    protected LinkedList steps = new LinkedList();
    protected boolean inPredicate = false;
    private long creationTime = 0L;

    public PathExpr(XQueryContext context) {
        super(context);
    }

    public void add(Expression s) {
        s.setParent(this);
        this.steps.add(s);
    }

    public void add(PathExpr path) {
        Iterator i = path.steps.iterator();
        while (i.hasNext()) {
            Expression expr = (Expression)i.next();
            this.add(expr);
        }
    }

    public void addPath(PathExpr path) {
        this.steps.add(path);
    }

    public void addPredicate(Predicate pred) {
        Expression e = (Expression)this.steps.getLast();
        if (e instanceof Step) {
            ((Step)e).addPredicate(pred);
        }
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Variable var;
        if (this.steps.size() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Sequence r = contextSequence != null ? contextSequence : Sequence.EMPTY_SEQUENCE;
        DocumentSet contextDocs = null;
        Expression expr = (Expression)this.steps.getFirst();
        if (expr instanceof VariableReference && (var = ((VariableReference)expr).getVariable()) != null) {
            contextDocs = var.getContextDocs();
        }
        Iterator iter = this.steps.iterator();
        while (iter.hasNext()) {
            expr = (Expression)iter.next();
            if (contextDocs != null) {
                expr.setContextDocSet(contextDocs);
            }
            if ((expr.getDependencies() & 2) != 0) {
                if (r.getLength() == 0) {
                    r = expr.eval(null, null);
                } else {
                    Sequence values = null;
                    if (r.getLength() > 1) {
                        values = new ValueSequence();
                    }
                    int pos = 0;
                    this.context.setContextPosition(0);
                    SequenceIterator iterInner = r.iterate();
                    while (iterInner.hasNext()) {
                        this.context.setContextPosition(pos);
                        Item current = iterInner.nextItem();
                        if (values == null) {
                            values = expr.eval(r, current);
                        } else {
                            values.addAll(expr.eval(r, current));
                        }
                        ++pos;
                    }
                    r = values;
                }
            } else {
                r = expr.eval(r);
            }
            if (this.steps.size() <= 1) continue;
            r.removeDuplicates();
        }
        return r;
    }

    public XQueryContext getContext() {
        return this.context;
    }

    public DocumentSet getDocumentSet() {
        return null;
    }

    public Expression getExpression(int pos) {
        return (Expression)this.steps.get(pos);
    }

    public Expression getLastExpression() {
        if (this.steps.size() == 0) {
            return null;
        }
        return (Expression)this.steps.getLast();
    }

    public int getLength() {
        return this.steps.size();
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        Iterator iter = this.steps.iterator();
        while (iter.hasNext()) {
            Expression next = (Expression)iter.next();
            if (buf.length() > 1 && next instanceof Step) {
                buf.append('/');
            }
            buf.append(next.pprint());
        }
        buf.append(')');
        return buf.toString();
    }

    public int returnsType() {
        if (this.steps.size() == 0) {
            return -1;
        }
        int rtype = ((Expression)this.steps.getLast()).returnsType();
        return rtype;
    }

    public int getDependencies() {
        int deps = 0;
        Iterator i = this.steps.iterator();
        while (i.hasNext()) {
            Expression next = (Expression)i.next();
            deps |= next.getDependencies();
        }
        return deps;
    }

    public void setFirstExpression(Expression s) {
        this.steps.addFirst(s);
    }

    public void replaceLastExpression(Expression s) {
        if (this.steps.size() == 0) {
            return;
        }
        this.steps.removeLast();
        this.steps.addLast(s);
    }

    public String getLiteralValue() {
        if (this.steps.size() == 0) {
            return "";
        }
        Expression next = (Expression)this.steps.get(0);
        if (next instanceof LiteralValue) {
            try {
                return ((LiteralValue)next).getValue().getStringValue();
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        if (next instanceof PathExpr) {
            return ((PathExpr)next).getLiteralValue();
        }
        return "";
    }

    public XQueryAST getASTNode() {
        XQueryAST ast = super.getASTNode();
        if (ast == null && this.steps.size() == 1) {
            return ((Expression)this.steps.get(0)).getASTNode();
        }
        return ast;
    }

    public void setInPredicate(boolean inPredicate) {
        this.inPredicate = inPredicate;
        if (this.steps.size() > 0) {
            ((Expression)this.steps.get(0)).setInPredicate(inPredicate);
        }
    }

    public void setPrimaryAxis(int axis) {
        if (this.steps.size() > 0) {
            ((Expression)this.steps.get(0)).setPrimaryAxis(axis);
        }
    }

    public void resetState() {
        Iterator i = this.steps.iterator();
        while (i.hasNext()) {
            ((Expression)i.next()).resetState();
        }
    }

    public void reset() {
        this.resetState();
    }

    public void setCreationTime(long created) {
        this.creationTime = created;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public boolean isValid() {
        return this.context.checkModulesValid();
    }
}

