/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NodeImpl;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class PIConstructor
extends NodeConstructor {
    private String target;
    private String data = null;

    public PIConstructor(XQueryContext context, String pi) throws XPathException {
        super(context);
        int p = pi.indexOf(32);
        if (p < 0) {
            throw new XPathException("Syntax error in processing instruction");
        }
        this.target = pi.substring(0, p);
        if (++p < pi.length()) {
            this.data = pi.substring(p);
        }
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        int nodeNr = builder.processingInstruction(this.target, this.data);
        NodeImpl node = builder.getDocument().getNode(nodeNr);
        return node;
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append("<?");
        buf.append(this.target);
        buf.append(' ');
        buf.append(this.data);
        buf.append("?>");
        return buf.toString();
    }
}

