/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.NodeSet;
import org.exist.storage.DBBroker;
import org.exist.xquery.Atomize;
import org.exist.xquery.BinaryOp;
import org.exist.xquery.Constants;
import org.exist.xquery.Expression;
import org.exist.xquery.UntypedValueCheck;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class OpNumeric
extends BinaryOp {
    protected int operator = 8;
    protected int returnType;
    protected NodeSet temp = null;
    protected DBBroker broker;

    public OpNumeric(XQueryContext context, int operator) {
        super(context);
        this.operator = operator;
    }

    public OpNumeric(XQueryContext context, Expression left, Expression right, int operator) {
        super(context);
        this.operator = operator;
        this.returnType = 20;
        int ltype = left.returnsType();
        int rtype = right.returnsType();
        if (!Type.subTypeOf(ltype, 20)) {
            left = new Atomize(context, left);
            ltype = 20;
        }
        if (!Type.subTypeOf(rtype, 20)) {
            right = new Atomize(context, right);
            rtype = 20;
        }
        if (Type.subTypeOf(ltype, 51) || Type.subTypeOf(ltype, 52)) {
            this.returnType = ltype;
        } else if (Type.subTypeOf(ltype, 30)) {
            if (Type.subTypeOf(rtype, 30)) {
                if (ltype > rtype) {
                    right = new UntypedValueCheck(context, ltype, right);
                    this.returnType = ltype;
                } else if (rtype > ltype) {
                    left = new UntypedValueCheck(context, rtype, left);
                    this.returnType = rtype;
                }
            }
        } else if (Type.subTypeOf(rtype, 30) && Type.subTypeOf(ltype, 30)) {
            if (rtype > ltype) {
                left = new UntypedValueCheck(context, rtype, left);
                this.returnType = rtype;
            } else if (rtype > ltype) {
                right = new UntypedValueCheck(context, ltype, right);
                this.returnType = ltype;
            }
        }
        if (this.returnType == 20) {
            this.returnType = left.returnsType();
        }
        this.add(left);
        this.add(right);
    }

    public int returnsType() {
        return this.returnType;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence lseq;
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((lseq = this.getLeft().eval(contextSequence)).getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Sequence rseq = this.getRight().eval(contextSequence);
        if (rseq.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Item lvalue = lseq.itemAt(0);
        Item rvalue = rseq.itemAt(0);
        try {
            if (!(lvalue instanceof ComputableValue)) {
                Item item = lvalue = this.operator == 13 ? lvalue.convertTo(31) : lvalue.convertTo(34);
            }
            if (!(rvalue instanceof ComputableValue)) {
                rvalue = this.operator == 13 ? rvalue.convertTo(31) : rvalue.convertTo(34);
            }
            int ltype = lvalue.getType();
            int rtype = rvalue.getType();
            if (Type.subTypeOf(ltype, 30)) {
                if (!Type.subTypeOf(rtype, 30)) {
                    rvalue = rvalue.convertTo(ltype);
                } else if (ltype > rtype) {
                    rvalue = rvalue.convertTo(ltype);
                } else if (rtype > ltype) {
                    lvalue = lvalue.convertTo(rtype);
                }
            } else if (Type.subTypeOf(rtype, 30)) {
                if (!Type.subTypeOf(ltype, 30)) {
                    lvalue = lvalue.convertTo(rtype);
                } else if (rtype > ltype) {
                    lvalue = lvalue.convertTo(rtype);
                } else if (rtype > ltype) {
                    rvalue = rvalue.convertTo(ltype);
                }
            }
            if (this.operator == 13) {
                return ((IntegerValue)lvalue).idiv((NumericValue)rvalue);
            }
            return this.applyOperator((ComputableValue)lvalue, (ComputableValue)rvalue);
        }
        catch (XPathException e) {
            e.setASTNode(this.getASTNode());
            throw e;
        }
    }

    public ComputableValue applyOperator(ComputableValue left, ComputableValue right) throws XPathException {
        switch (this.operator) {
            case 9: {
                return left.minus(right);
            }
            case 8: {
                return left.plus(right);
            }
            case 10: {
                return left.mult(right);
            }
            case 11: {
                return left.div(right);
            }
            case 12: {
                return ((NumericValue)left).mod((NumericValue)right);
            }
        }
        return null;
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getLeft().pprint());
        buf.append(' ');
        buf.append(Constants.OPS[this.operator]);
        buf.append(' ');
        buf.append(this.getRight().pprint());
        return buf.toString();
    }
}

