/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.xquery.TypeTest;
import org.w3c.dom.Node;

public class NameTest
extends TypeTest {
    protected QName nodeName;

    public NameTest(int type, QName name) {
        super(type);
        this.nodeName = name;
    }

    public QName getName() {
        return this.nodeName;
    }

    public boolean matches(NodeProxy proxy) {
        Node node = null;
        short type = proxy.nodeType;
        if (proxy.getType() == 11) {
            node = proxy.getNode();
            type = node.getNodeType();
        }
        if (!this.isOfType(type)) {
            return false;
        }
        if (node == null) {
            node = proxy.getNode();
        }
        return this.matchesInternal(node);
    }

    public boolean matches(Node other) {
        if (!this.isOfType(other.getNodeType())) {
            return false;
        }
        return this.matchesInternal(other);
    }

    private boolean matchesInternal(Node other) {
        if (this.nodeName.getNamespaceURI() != null && !this.nodeName.getNamespaceURI().equals(other.getNamespaceURI())) {
            return false;
        }
        if (this.nodeName.getLocalName() != null) {
            return this.nodeName.getLocalName().equals(other.getLocalName());
        }
        return true;
    }

    public boolean isWildcardTest() {
        return this.nodeName.getLocalName() == null || this.nodeName.getNamespaceURI() == null;
    }

    public String toString() {
        return this.nodeName.toString();
    }
}

