/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.exist.dom.QName;
import org.exist.xquery.Function;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;

public class JavaCall
extends Function {
    private QName qname;
    private String name;
    private Class myClass = null;
    private List candidateMethods = new ArrayList(5);

    public JavaCall(XQueryContext context, QName qname) throws XPathException {
        super(context, null);
        this.qname = qname;
        String namespaceURI = context.getURIForPrefix(qname.getPrefix());
        if (!namespaceURI.startsWith("java:")) {
            throw new XPathException(this.getASTNode(), "Internal error: prefix " + qname.getPrefix() + " does not " + "resolve to a Java class");
        }
        namespaceURI = namespaceURI.substring("java:".length());
        try {
            LOG.debug((Object)("Trying to find class " + namespaceURI));
            this.myClass = Class.forName(namespaceURI);
        }
        catch (ClassNotFoundException e) {
            throw new XPathException(this.getASTNode(), "Class: " + namespaceURI + " not found");
        }
        this.name = qname.getLocalName();
        if (this.name.indexOf(45) > 0) {
            StringBuffer buf = new StringBuffer();
            boolean afterHyphen = false;
            for (int i = 0; i < this.name.length(); ++i) {
                char ch = this.name.charAt(i);
                if (ch == '-') {
                    afterHyphen = true;
                    continue;
                }
                if (afterHyphen) {
                    buf.append(Character.toUpperCase(ch));
                    afterHyphen = false;
                    continue;
                }
                buf.append(ch);
            }
            this.name = buf.toString();
            LOG.debug((Object)("converted method name to " + this.name));
        }
    }

    public QName getName() {
        return this.qname;
    }

    public void setArguments(List arguments) throws XPathException {
        int argCount = arguments.size();
        for (int i = 0; i < argCount; ++i) {
            this.steps.add(arguments.get(i));
        }
        if (this.name.equals("new")) {
            Constructor<?>[] constructors = this.myClass.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Class<?>[] paramTypes;
                if (!Modifier.isPublic(constructors[i].getModifiers()) || (paramTypes = constructors[i].getParameterTypes()).length != argCount) continue;
                LOG.debug((Object)("Found constructor " + constructors[i].toString()));
                this.candidateMethods.add(constructors[i]);
            }
            if (this.candidateMethods.size() == 0) {
                throw new XPathException(this.getASTNode(), "no constructor found with " + argCount + " arguments");
            }
        } else {
            Method[] methods = this.myClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!Modifier.isPublic(methods[i].getModifiers()) || !methods[i].getName().equals(this.name)) continue;
                Class<?>[] paramTypes = methods[i].getParameterTypes();
                if (Modifier.isStatic(methods[i].getModifiers())) {
                    if (paramTypes.length != argCount) continue;
                    LOG.debug((Object)("Found static method " + methods[i].toString()));
                    this.candidateMethods.add(methods[i]);
                    continue;
                }
                if (paramTypes.length != argCount - 1) continue;
                LOG.debug((Object)("Found method " + methods[i].toString()));
                this.candidateMethods.add(methods[i]);
            }
            if (this.candidateMethods.size() == 0) {
                throw new XPathException(this.getASTNode(), "no method matches " + this.name + " with " + argCount + " arguments");
            }
        }
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        int i;
        Sequence[] args = this.getArguments(contextSequence, contextItem);
        AccessibleObject bestMethod = (AccessibleObject)this.candidateMethods.get(0);
        int[] conversionPrefs = this.getConversionPreferences(bestMethod, args);
        block6: for (int i2 = 1; i2 < this.candidateMethods.size(); ++i2) {
            AccessibleObject nextMethod = (AccessibleObject)this.candidateMethods.get(i2);
            int[] prefs = this.getConversionPreferences(nextMethod, args);
            for (int j = 0; j < prefs.length; ++j) {
                if (prefs[j] >= conversionPrefs[j]) continue;
                bestMethod = nextMethod;
                conversionPrefs = prefs;
                continue block6;
            }
        }
        Class<?>[] paramTypes = null;
        boolean isStatic = true;
        if (bestMethod instanceof Constructor) {
            paramTypes = ((Constructor)bestMethod).getParameterTypes();
        } else {
            paramTypes = ((Method)bestMethod).getParameterTypes();
            isStatic = Modifier.isStatic(((Method)bestMethod).getModifiers());
        }
        Object[] params = new Object[isStatic ? args.length : args.length - 1];
        if (isStatic) {
            for (i = 0; i < args.length; ++i) {
                params[i] = args[i].toJavaObject(paramTypes[i]);
            }
        } else {
            for (i = 1; i < args.length; ++i) {
                params[i - 1] = args[i].toJavaObject(paramTypes[i - 1]);
            }
        }
        if (bestMethod instanceof Constructor) {
            try {
                Object object = ((Constructor)bestMethod).newInstance(params);
                return new JavaObjectValue(object);
            }
            catch (IllegalArgumentException e) {
                throw new XPathException(this.getASTNode(), "illegal argument to constructor " + bestMethod.toString() + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                if (e instanceof XPathException) {
                    throw (XPathException)e;
                }
                throw new XPathException(this.getASTNode(), "exception while calling constructor " + bestMethod.toString() + ": " + e.getMessage(), e);
            }
        }
        try {
            Object result = null;
            result = isStatic ? ((Method)bestMethod).invoke(null, params) : ((Method)bestMethod).invoke(args[0].toJavaObject(this.myClass), params);
            return XPathUtil.javaObjectToXPath(result);
        }
        catch (IllegalArgumentException e) {
            throw new XPathException(this.getASTNode(), "illegal argument to method " + bestMethod.toString() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (e instanceof XPathException) {
                throw (XPathException)e;
            }
            throw new XPathException(this.getASTNode(), "exception while calling method " + bestMethod.toString() + ": " + e.getMessage(), e);
        }
    }

    public int returnsType() {
        return 11;
    }

    private int[] getConversionPreferences(AccessibleObject method, Sequence[] args) {
        int[] prefs = new int[args.length];
        Class<?>[] paramTypes = null;
        boolean isStatic = true;
        if (method instanceof Constructor) {
            paramTypes = ((Constructor)method).getParameterTypes();
        } else {
            paramTypes = ((Method)method).getParameterTypes();
            isStatic = Modifier.isStatic(((Method)method).getModifiers());
            if (!isStatic) {
                Class[] nonStaticTypes = new Class[paramTypes.length + 1];
                nonStaticTypes[0] = this.myClass;
                System.arraycopy(paramTypes, 0, nonStaticTypes, 1, paramTypes.length);
                paramTypes = nonStaticTypes;
            }
        }
        for (int i = 0; i < args.length; ++i) {
            prefs[i] = args[i].conversionPreference(paramTypes[i]);
        }
        return prefs;
    }
}

