/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.NodeSet;
import org.exist.xquery.CombiningExpression;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class Intersection
extends CombiningExpression {
    public Intersection(XQueryContext context, PathExpr left, PathExpr right) {
        super(context, left, right);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence lval = this.left.eval(contextSequence, contextItem);
        Sequence rval = this.right.eval(contextSequence, contextItem);
        if (lval.getLength() == 0 || rval.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (!Type.subTypeOf(lval.getItemType(), -1) || !Type.subTypeOf(rval.getItemType(), -1)) {
            throw new XPathException("intersect operand is not a node sequence");
        }
        NodeSet result = lval.toNodeSet().intersection(rval.toNodeSet());
        return result;
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.left.pprint());
        buf.append(" intersect ");
        buf.append(this.right.pprint());
        return buf.toString();
    }
}

