/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.AbstractExpression;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class InstanceOfExpression
extends AbstractExpression {
    private Expression expression;
    private SequenceType type;

    public InstanceOfExpression(XQueryContext context, Expression expr, SequenceType type) {
        super(context);
        this.expression = expr;
        this.type = type;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq = this.expression.eval(contextSequence, contextItem);
        int items = seq.getLength();
        int requiredCardinality = this.type.getCardinality();
        if (items > 0 && requiredCardinality == 1) {
            return BooleanValue.FALSE;
        }
        if (items == 0 && (requiredCardinality & 1) == 0) {
            return BooleanValue.FALSE;
        }
        if (items > 1 && (requiredCardinality & 4) == 0) {
            return BooleanValue.FALSE;
        }
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Item next = i.nextItem();
            if (Type.subTypeOf(next.getType(), this.type.getPrimaryType())) continue;
            return BooleanValue.FALSE;
        }
        return BooleanValue.TRUE;
    }

    public String pprint() {
        return this.expression.pprint() + " instance of " + this.type.toString();
    }

    public int returnsType() {
        return 23;
    }

    public int getCardinality() {
        return 2;
    }

    public int getDependencies() {
        return 3;
    }

    public void resetState() {
        this.expression.resetState();
    }
}

