/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.Expression;
import org.exist.xquery.Predicate;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class FilteredExpression
extends AbstractExpression {
    protected Expression expression;
    protected List predicates = new ArrayList(2);

    public FilteredExpression(XQueryContext context, Expression expr) {
        super(context);
        this.expression = expr;
    }

    public void addPredicate(Predicate pred) {
        this.predicates.add(pred);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq;
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((seq = this.expression.eval(contextSequence, contextItem)).getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        seq.setSelfAsContext();
        Sequence result = seq;
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            Predicate pred = (Predicate)i.next();
            result = pred.evalPredicate(contextSequence, result, 8);
        }
        return result;
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.expression.pprint());
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            buf.append('[');
            buf.append(((Expression)i.next()).pprint());
            buf.append(']');
        }
        return buf.toString();
    }

    public int returnsType() {
        return this.expression.returnsType();
    }

    public void resetState() {
        this.expression.resetState();
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            Predicate pred = (Predicate)i.next();
            pred.resetState();
        }
    }

    public void setPrimaryAxis(int axis) {
        this.expression.setPrimaryAxis(axis);
    }

    public int getDependencies() {
        int deps = 1;
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            deps |= ((Predicate)i.next()).getDependencies();
        }
        return deps;
    }
}

