/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import org.exist.dom.QName;
import org.exist.source.Source;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.Variable;
import org.exist.xquery.VariableDeclaration;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;

public class ExternalModuleImpl
implements ExternalModule {
    private String mNamespaceURI;
    private String mPrefix;
    private TreeMap mFunctionMap = new TreeMap();
    private TreeMap mGlobalVariables = new TreeMap();
    private TreeMap mStaticVariables = new TreeMap();
    private Source mSource = null;
    private XQueryContext mContext = null;

    public ExternalModuleImpl(String namespaceURI, String prefix) {
        this.mNamespaceURI = namespaceURI;
        this.mPrefix = prefix;
    }

    public String getDescription() {
        return "User defined module";
    }

    public UserDefinedFunction getFunction(QName qname) {
        return (UserDefinedFunction)this.mFunctionMap.get(qname);
    }

    public void declareFunction(UserDefinedFunction func) {
        this.mFunctionMap.put(func.getSignature().getName(), func);
    }

    public String getNamespaceURI() {
        return this.mNamespaceURI;
    }

    public String getDefaultPrefix() {
        return this.mPrefix;
    }

    public boolean isInternalModule() {
        return false;
    }

    public FunctionSignature[] listFunctions() {
        FunctionSignature[] signatures = new FunctionSignature[this.mFunctionMap.size()];
        int j = 0;
        Iterator i = this.mFunctionMap.values().iterator();
        while (i.hasNext()) {
            signatures[j] = ((UserDefinedFunction)i.next()).getSignature();
            ++j;
        }
        return signatures;
    }

    public Iterator getSignaturesForFunction(QName qname) {
        LinkedList<FunctionSignature> list = new LinkedList<FunctionSignature>();
        UserDefinedFunction func = (UserDefinedFunction)this.mFunctionMap.get(qname);
        if (func != null) {
            list.add(func.getSignature());
        }
        return list.iterator();
    }

    public Variable declareVariable(QName qname, Object value) throws XPathException {
        Sequence val = XPathUtil.javaObjectToXPath(value);
        Variable var = (Variable)this.mStaticVariables.get(qname);
        if (var == null) {
            var = new Variable(qname);
            this.mStaticVariables.put(qname, var);
        }
        var.setValue(val);
        return var;
    }

    public void declareVariable(QName qname, VariableDeclaration decl) throws XPathException {
        this.mGlobalVariables.put(qname, decl);
    }

    public Variable resolveVariable(QName qname) throws XPathException {
        VariableDeclaration decl = (VariableDeclaration)this.mGlobalVariables.get(qname);
        if (decl != null) {
            decl.eval(null);
        }
        return (Variable)this.mStaticVariables.get(qname);
    }

    public void setSource(Source source) {
        this.mSource = source;
    }

    public void setContext(XQueryContext context) {
        this.mContext = context;
    }

    public boolean moduleIsValid() {
        if (this.mSource.isValid() != 1) {
            return false;
        }
        return this.mContext.checkModulesValid();
    }
}

