/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public class DynamicPIConstructor
extends NodeConstructor {
    private Expression name;
    private Expression content;

    public DynamicPIConstructor(XQueryContext context) {
        super(context);
    }

    public void setNameExpr(Expression nameExpr) {
        this.name = nameExpr;
    }

    public void setContentExpr(Expression contentExpr) {
        this.content = contentExpr;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        String value;
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        this.context.proceed(this, builder);
        Sequence nameSeq = this.name.eval(contextSequence, contextItem);
        if (nameSeq.getLength() != 1) {
            throw new XPathException(this.getASTNode(), "The name expression should evaluate to a single value");
        }
        Item nameItem = nameSeq.itemAt(0);
        if (nameItem.getType() != 22 && nameItem.getType() != 24) {
            throw new XPathException(this.getASTNode(), "The name expression should evaluate to a string or qname");
        }
        QName qn = QName.parse(this.context, nameSeq.getStringValue());
        Sequence contentSeq = this.content.eval(contextSequence, contextItem);
        if (contentSeq.getLength() == 0) {
            value = "";
        } else {
            StringBuffer buf = new StringBuffer();
            SequenceIterator i = contentSeq.iterate();
            while (i.hasNext()) {
                this.context.proceed(this, builder);
                Item next = i.nextItem();
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(next.toString());
            }
            value = buf.toString();
        }
        int nodeNr = builder.processingInstruction(qn.getLocalName(), value);
        return builder.getDocument().getNode(nodeNr);
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append("processing-instruction { ").append(this.name.pprint());
        buf.append(" } { ").append(this.content.pprint()).append(" }");
        return buf.toString();
    }
}

