/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.AbstractExpression;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class DynamicCardinalityCheck
extends AbstractExpression {
    private Expression expression;
    private int requiredCardinality;

    public DynamicCardinalityCheck(XQueryContext context, int requiredCardinality, Expression expr) {
        super(context);
        this.requiredCardinality = requiredCardinality;
        this.expression = expr;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq = this.expression.eval(contextSequence, contextItem);
        int items = seq.getLength();
        if (items > 0 && this.requiredCardinality == 1) {
            throw new XPathException(this.getASTNode(), "Empty sequence expected; got " + items);
        }
        if (items == 0 && (this.requiredCardinality & 1) == 0) {
            throw new XPathException(this.getASTNode(), "Empty sequence is not allowed here");
        }
        if (items > 1 && (this.requiredCardinality & 4) == 0) {
            throw new XPathException(this.getASTNode(), "Sequence with more than one item is not allowed here");
        }
        return seq;
    }

    public String pprint() {
        return this.expression.pprint();
    }

    public int returnsType() {
        return this.expression.returnsType();
    }

    public int getDependencies() {
        return this.expression.getDependencies();
    }

    public void resetState() {
        this.expression.resetState();
    }
}

