/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NodeImpl;
import org.exist.xquery.Atomize;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public class DynamicAttributeConstructor
extends NodeConstructor {
    private Expression qnameExpr;
    private Expression valueExpr;

    public DynamicAttributeConstructor(XQueryContext context) {
        super(context);
    }

    public void setNameExpr(Expression expr) {
        this.qnameExpr = new Atomize(this.context, expr);
    }

    public void setContentExpr(Expression expr) {
        this.valueExpr = new Atomize(this.context, expr);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        String value;
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        this.context.proceed(this, builder);
        Sequence nameSeq = this.qnameExpr.eval(contextSequence, contextItem);
        if (nameSeq.getLength() != 1) {
            throw new XPathException(this.getASTNode(), "The name expression should evaluate to a single value");
        }
        QName qn = QName.parse(this.context, nameSeq.getStringValue());
        Sequence valueSeq = this.valueExpr.eval(contextSequence, contextItem);
        if (valueSeq.getLength() == 0) {
            value = "";
        } else {
            StringBuffer buf = new StringBuffer();
            SequenceIterator i = valueSeq.iterate();
            while (i.hasNext()) {
                Item next = i.nextItem();
                buf.append(next.getStringValue());
                if (!i.hasNext()) continue;
                buf.append(' ');
            }
            value = buf.toString();
        }
        int nodeNr = builder.addAttribute(qn, value);
        NodeImpl node = builder.getDocument().getAttribute(nodeNr);
        return node;
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append("attribute { ");
        buf.append(this.qnameExpr.pprint());
        buf.append(" } { ");
        buf.append(this.valueExpr.pprint());
        buf.append(" }");
        return buf.toString();
    }
}

