/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.memtree.DocumentImpl;
import org.exist.memtree.MemTreeBuilder;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.xml.sax.SAXException;

public class DocumentConstructor
extends NodeConstructor {
    private Expression content;

    public DocumentConstructor(XQueryContext context, Expression contentExpr) {
        super(context);
        this.content = contentExpr;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        System.out.println(this.content.pprint());
        Sequence contentSeq = this.content.eval(contextSequence, contextItem);
        this.context.pushDocumentContext();
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
        if (contentSeq.getLength() == 0) {
            return builder.getDocument();
        }
        try {
            StringBuffer buf = null;
            SequenceIterator i = contentSeq.iterate();
            Item next = i.nextItem();
            while (next != null) {
                this.context.proceed(this, builder);
                if (next.getType() == 2 || next.getType() == 500 || next.getType() == 6) {
                    throw new XPathException(this.getASTNode(), "Found a node of type " + Type.getTypeName(next.getType()) + " inside a document constructor");
                }
                if (Type.subTypeOf(next.getType(), 20)) {
                    if (buf == null) {
                        buf = new StringBuffer();
                    } else if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    buf.append(next.getStringValue());
                    next = i.nextItem();
                    continue;
                }
                if (!Type.subTypeOf(next.getType(), -1)) continue;
                if (buf != null && buf.length() > 0) {
                    receiver.characters(buf);
                    buf.setLength(0);
                }
                next.copyTo(this.context.getBroker(), receiver);
                next = i.nextItem();
            }
            if (buf != null && buf.length() > 0) {
                receiver.characters(buf);
            }
        }
        catch (SAXException e) {
            throw new XPathException(this.getASTNode(), "Encountered SAX exception while processing document constructor: " + this.pprint());
        }
        DocumentImpl node = builder.getDocument();
        this.context.popDocumentContext();
        return node;
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append("document { ").append(this.content.pprint()).append(" }");
        return buf.toString();
    }
}

