/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class ConditionalExpression
extends AbstractExpression {
    private Expression testExpr;
    private Expression thenExpr;
    private Expression elseExpr;

    public ConditionalExpression(XQueryContext context, Expression testExpr, Expression thenExpr, Expression elseExpr) {
        super(context);
        this.testExpr = testExpr;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
    }

    public int getDependencies() {
        return 3;
    }

    public int getCardinality() {
        return this.thenExpr.getCardinality() | this.elseExpr.getCardinality();
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence testSeq = this.testExpr.eval(contextSequence, contextItem);
        if (testSeq.effectiveBooleanValue()) {
            return this.thenExpr.eval(contextSequence, contextItem);
        }
        return this.elseExpr.eval(contextSequence, contextItem);
    }

    public DocumentSet preselect(DocumentSet in_docs) throws XPathException {
        return in_docs;
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append("if ");
        buf.append(this.testExpr.pprint());
        buf.append(" then ");
        buf.append(this.thenExpr.pprint());
        buf.append(" else ");
        buf.append(this.elseExpr.pprint());
        return buf.toString();
    }

    public int returnsType() {
        if (this.thenExpr.returnsType() == this.elseExpr.returnsType()) {
            return this.thenExpr.returnsType();
        }
        return 11;
    }

    public void resetState() {
        this.testExpr.resetState();
        this.thenExpr.resetState();
        this.elseExpr.resetState();
    }
}

