/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.AbstractExpression;
import org.exist.xquery.Atomize;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class CastableExpression
extends AbstractExpression {
    private Expression expression;
    private int requiredType;
    private int cardinality = 2;

    public CastableExpression(XQueryContext context, Expression expr, int requiredType, int cardinality) {
        super(context);
        this.expression = expr;
        this.requiredType = requiredType;
        this.cardinality = cardinality;
        if (!Type.subTypeOf(this.expression.returnsType(), 20)) {
            this.expression = new Atomize(context, this.expression);
        }
    }

    public int returnsType() {
        return 23;
    }

    public int getCardinality() {
        return 2;
    }

    public int getDependencies() {
        return 3;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq = this.expression.eval(contextSequence, contextItem);
        if (seq.getLength() == 0) {
            if ((this.cardinality & 1) == 0) {
                return BooleanValue.FALSE;
            }
            return BooleanValue.TRUE;
        }
        try {
            seq.itemAt(0).convertTo(this.requiredType);
            return BooleanValue.TRUE;
        }
        catch (XPathException e) {
            return BooleanValue.FALSE;
        }
    }

    public String pprint() {
        return "(" + this.expression.pprint() + " castable as " + Type.getTypeName(this.requiredType) + ")";
    }

    public void resetState() {
        this.expression.resetState();
    }
}

