/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.AbstractExpression;
import org.exist.xquery.Atomize;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class CastExpression
extends AbstractExpression {
    private Expression expression;
    private int requiredType;
    private int cardinality = 2;

    public CastExpression(XQueryContext context, Expression expr, int requiredType, int cardinality) {
        super(context);
        this.expression = expr;
        this.requiredType = requiredType;
        this.cardinality = cardinality;
        if (!Type.subTypeOf(this.expression.returnsType(), 20)) {
            this.expression = new Atomize(context, this.expression);
        }
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq = this.expression.eval(contextSequence, contextItem);
        if (seq.getLength() == 0) {
            if ((this.cardinality & 1) == 0) {
                throw new XPathException(this.getASTNode(), "Type error: empty sequence is not allowed here");
            }
            return Sequence.EMPTY_SEQUENCE;
        }
        try {
            return seq.itemAt(0).convertTo(this.requiredType);
        }
        catch (XPathException e) {
            e.setASTNode(this.getASTNode());
            throw e;
        }
    }

    public String pprint() {
        return "(" + this.expression.pprint() + " cast as " + Type.getTypeName(this.requiredType) + ")";
    }

    public int returnsType() {
        return this.requiredType;
    }

    public int getDependencies() {
        return 3;
    }

    public int getCardinality() {
        return 3;
    }

    public void resetState() {
        this.expression.resetState();
    }
}

