/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.exist.dom.ContextItem;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.VirtualNodeSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.Expression;
import org.exist.xquery.OrderSpec;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public abstract class BindingExpression
extends AbstractExpression {
    protected static final Logger LOG = Logger.getLogger((Class)BindingExpression.class);
    protected String varName;
    protected SequenceType sequenceType = null;
    protected Expression inputSequence;
    protected Expression returnExpr;
    protected Expression whereExpr;
    protected OrderSpec[] orderSpecs = null;

    public BindingExpression(XQueryContext context) {
        super(context);
    }

    public void setVariable(String qname) {
        this.varName = qname;
    }

    public void setSequenceType(SequenceType type) {
        this.sequenceType = type;
    }

    public void setInputSequence(Expression sequence) {
        this.inputSequence = sequence;
    }

    public void setReturnExpression(Expression expr) {
        this.returnExpr = expr;
    }

    public void setWhereExpression(Expression expr) {
        this.whereExpr = expr;
    }

    public void setOrderSpecs(OrderSpec[] specs) {
        this.orderSpecs = specs;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        return this.eval(contextSequence, contextItem, null);
    }

    public abstract Sequence eval(Sequence var1, Item var2, Sequence var3) throws XPathException;

    protected Sequence applyWhereExpression(Sequence contextSequence) throws XPathException {
        this.whereExpr.setInPredicate(true);
        if (Type.subTypeOf(this.whereExpr.returnsType(), -1) && (contextSequence == null || Type.subTypeOf(contextSequence.getItemType(), -1))) {
            NodeSet contextSet = contextSequence.toNodeSet();
            boolean contextIsVirtual = contextSet instanceof VirtualNodeSet;
            NodeSet nodes = this.whereExpr.eval(contextSequence).toNodeSet();
            DocumentImpl lastDoc = null;
            int count = 0;
            int sizeHint = -1;
            ExtArrayNodeSet result = new ExtArrayNodeSet();
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                ContextItem contextNode;
                NodeProxy current = (NodeProxy)i.next();
                if (lastDoc == null || current.getDocument() != lastDoc) {
                    lastDoc = current.getDocument();
                    sizeHint = nodes.getSizeHint(lastDoc);
                }
                if ((contextNode = current.getContext()) == null) {
                    throw new XPathException("Internal evaluation error: context node is missing for node " + current.gid + "!");
                }
                while (contextNode != null) {
                    NodeProxy next = contextNode.getNode();
                    if (contextIsVirtual || contextSet.contains(next)) {
                        next.addMatches(current);
                        result.add(next, sizeHint);
                    }
                    contextNode = contextNode.getNextItem();
                }
                ++count;
            }
            return result;
        }
        if (contextSequence == null) {
            Sequence innerSeq = this.whereExpr.eval(null);
            return innerSeq.effectiveBooleanValue() ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
        ValueSequence result = new ValueSequence();
        int p = 0;
        this.context.setContextPosition(0);
        SequenceIterator i = contextSequence.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            this.context.setContextPosition(p);
            Sequence innerSeq = this.whereExpr.eval(contextSequence, item);
            if (innerSeq.effectiveBooleanValue()) {
                result.add(item);
            }
            ++p;
        }
        return result;
    }

    protected boolean checkOrderSpecs(Sequence in) {
        if (this.orderSpecs == null) {
            return false;
        }
        if (!Type.subTypeOf(in.getItemType(), -1)) {
            return false;
        }
        for (int i = 0; i < this.orderSpecs.length; ++i) {
            Expression expr = this.orderSpecs[i].getSortExpression();
            if (Type.subTypeOf(expr.returnsType(), -1) && (expr.getDependencies() & 2) == 0) continue;
            return false;
        }
        return true;
    }

    public DocumentSet preselect(DocumentSet in_docs) throws XPathException {
        return in_docs;
    }

    public abstract String pprint();

    public int returnsType() {
        return 11;
    }

    public void resetState() {
        this.inputSequence.resetState();
        if (this.whereExpr != null) {
            this.whereExpr.resetState();
        }
        this.returnExpr.resetState();
        if (this.orderSpecs != null) {
            for (int i = 0; i < this.orderSpecs.length; ++i) {
                this.orderSpecs[i].resetState();
            }
        }
    }

    protected static final void setContext(Sequence seq) {
        SequenceIterator i = seq.unorderedIterator();
        while (i.hasNext()) {
            Item next = i.nextItem();
            if (!(next instanceof NodeProxy)) continue;
            ((NodeProxy)next).addContextNode((NodeProxy)next);
        }
    }

    protected static final void clearContext(Sequence seq) {
        SequenceIterator i = seq.unorderedIterator();
        while (i.hasNext()) {
            Item next = i.nextItem();
            if (!(next instanceof NodeProxy)) continue;
            ((NodeProxy)next).clearContext();
        }
    }
}

