/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.AbstractExpression;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.ValueSequence;

public class Atomize
extends AbstractExpression {
    private Expression expression;

    public Atomize(XQueryContext context, Expression expr) {
        super(context);
        this.expression = expr;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq = this.expression.eval(contextSequence, contextItem);
        ValueSequence result = new ValueSequence();
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Item next = i.nextItem();
            result.add(next.atomize());
        }
        return result;
    }

    public String pprint() {
        return "#atomize(" + this.expression.pprint() + ')';
    }

    public int returnsType() {
        return 20;
    }

    public int getDependencies() {
        return this.expression.getDependencies();
    }

    public void resetState() {
        this.expression.resetState();
    }

    public XQueryAST getASTNode() {
        return this.expression.getASTNode();
    }
}

