/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmlrpc;

import antlr.collections.AST;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.ArraySet;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.dom.SortedNodeSet;
import org.exist.memtree.NodeImpl;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.source.StringSource;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.storage.serializers.Serializer;
import org.exist.util.Configuration;
import org.exist.util.LockException;
import org.exist.util.Occurrences;
import org.exist.util.SyntaxException;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SAXSerializerPool;
import org.exist.xmlrpc.QueryResult;
import org.exist.xmlrpc.RpcServer;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Pragma;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryLexer;
import org.exist.xquery.parser.XQueryParser;
import org.exist.xquery.parser.XQueryTreeParser;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xupdate.Modification;
import org.exist.xupdate.XUpdateProcessor;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class RpcConnection
extends Thread {
    private static final Logger LOG = Logger.getLogger((Class)RpcConnection.class);
    public static final String EXIST_NS = "http://exist.sourceforge.net/NS/exist";
    protected BrokerPool brokerPool;
    protected WeakHashMap documentCache = new WeakHashMap();
    protected boolean terminate = false;
    protected List cachedExpressions = new LinkedList();
    protected RpcServer.ConnectionPool connectionPool;
    private static final int MAX_DOWNLOAD_CHUNK_SIZE = 262144;

    public RpcConnection(Configuration conf, RpcServer.ConnectionPool pool) throws EXistException {
        this.connectionPool = pool;
        this.brokerPool = BrokerPool.getInstance();
    }

    public void createCollection(User user, String name) throws Exception, PermissionDeniedException {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            Collection current = broker.getOrCreateCollection(name);
            LOG.debug((Object)("creating collection " + name));
            broker.saveCollection(current);
            broker.flush();
            LOG.debug((Object)("collection " + name + " has been created"));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
            throw e;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createId(User user, String collName) throws EXistException {
        DBBroker broker = this.brokerPool.get(user);
        Collection collection = null;
        try {
            String id;
            boolean ok;
            collection = broker.openCollection(collName, 0);
            if (collection == null) {
                throw new EXistException("collection " + collName + " not found!");
            }
            Random rand = new Random();
            do {
                ok = true;
                id = Integer.toHexString(rand.nextInt()) + ".xml";
                if (collection.hasDocument(id)) {
                    ok = false;
                }
                if (!collection.hasSubcollection(id)) continue;
                ok = false;
            } while (!ok);
            String string = id;
            Object var10_9 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            return string;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    protected PathExpr compile(User user, DBBroker broker, String xquery, Hashtable parameters) throws Exception {
        Hashtable variableDecls;
        String baseURI = (String)parameters.get("base-uri");
        XQueryContext context = new XQueryContext(broker);
        context.setBaseURI(baseURI);
        Hashtable namespaces = (Hashtable)parameters.get("namespaces");
        if (namespaces != null && namespaces.size() > 0) {
            context.declareNamespaces(namespaces);
        }
        if ((variableDecls = (Hashtable)parameters.get("variables")) != null) {
            Iterator i = variableDecls.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                LOG.debug((Object)("declaring " + entry.getKey().toString() + " = " + entry.getValue()));
                context.declareVariable((String)entry.getKey(), entry.getValue());
            }
        }
        LOG.debug((Object)("compiling " + xquery));
        XQueryLexer lexer = new XQueryLexer(context, new StringReader(xquery));
        XQueryParser parser = new XQueryParser(lexer);
        XQueryTreeParser treeParser = new XQueryTreeParser(context);
        parser.xpath();
        if (parser.foundErrors()) {
            throw new EXistException(parser.getErrorMessage());
        }
        AST ast = parser.getAST();
        PathExpr expr = new PathExpr(context);
        treeParser.xpath(ast, expr);
        if (treeParser.foundErrors()) {
            throw new EXistException(treeParser.getErrorMessage());
        }
        return expr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueryResult doQuery(User user, DBBroker broker, String xpath, NodeSet contextSet, Hashtable parameters) throws Exception {
        Vector staticDocuments;
        Hashtable variableDecls;
        String baseURI = (String)parameters.get("base-uri");
        StringSource source = new StringSource(xpath);
        XQuery xquery = broker.getXQueryService();
        XQueryPool pool = xquery.getXQueryPool();
        CompiledXQuery compiled = pool.borrowCompiledXQuery(source);
        XQueryContext context = compiled == null ? xquery.newContext() : compiled.getContext();
        context.setBaseURI(baseURI);
        Hashtable namespaces = (Hashtable)parameters.get("namespaces");
        if (namespaces != null && namespaces.size() > 0) {
            context.declareNamespaces(namespaces);
        }
        if ((variableDecls = (Hashtable)parameters.get("variables")) != null) {
            Iterator i = variableDecls.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                LOG.debug((Object)("declaring " + entry.getKey().toString() + " = " + entry.getValue()));
                context.declareVariable((String)entry.getKey(), entry.getValue());
            }
        }
        if ((staticDocuments = (Vector)parameters.get("static-documents")) != null) {
            String[] d = new String[staticDocuments.size()];
            int j = 0;
            Iterator i = staticDocuments.iterator();
            while (i.hasNext()) {
                String next;
                d[j] = next = (String)i.next();
                ++j;
            }
            context.setStaticallyKnownDocuments(d);
        } else if (baseURI != null) {
            context.setStaticallyKnownDocuments(new String[]{baseURI});
        }
        try {
            if (compiled == null) {
                compiled = xquery.compile(context, source);
            }
            this.checkPragmas(context, parameters);
            long start = System.currentTimeMillis();
            Sequence result = xquery.execute(compiled, contextSet);
            LOG.info((Object)("query took " + (System.currentTimeMillis() - start) + "ms."));
            QueryResult queryResult = new QueryResult(context, result);
            Object var20_22 = null;
            if (compiled != null) {
                pool.returnCompiledXQuery(source, compiled);
            }
            return queryResult;
        }
        catch (XPathException e) {
            try {
                QueryResult queryResult = new QueryResult(e);
                Object var20_23 = null;
                if (compiled != null) {
                    pool.returnCompiledXQuery(source, compiled);
                }
                return queryResult;
            }
            catch (Throwable throwable) {
                block14: {
                    Object var20_24 = null;
                    if (compiled == null) break block14;
                    pool.returnCompiledXQuery(source, compiled);
                }
                throw throwable;
            }
        }
    }

    protected void checkPragmas(XQueryContext context, Hashtable parameters) throws XPathException {
        Pragma pragma = context.getPragma(Pragma.SERIALIZE_QNAME);
        if (pragma == null) {
            return;
        }
        String[] contents = pragma.tokenizeContents();
        for (int i = 0; i < contents.length; ++i) {
            String[] pair = Pragma.parseKeyValuePair(contents[i]);
            if (pair == null) {
                throw new XPathException("Unknown parameter found in " + pragma.getQName().toString() + ": '" + contents[i] + "'");
            }
            LOG.debug((Object)("Setting serialization property from pragma: " + pair[0] + " = " + pair[1]));
            parameters.put(pair[0], pair[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeQuery(User user, String xpath, Hashtable parameters) throws Exception {
        long startTime = System.currentTimeMillis();
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            QueryResult result = this.doQuery(user, broker, xpath, null, parameters);
            if (result.hasErrors()) {
                throw result.getException();
            }
            result.queryTime = System.currentTimeMillis() - startTime;
            this.connectionPool.resultSets.put(result.hashCode(), result);
            int n = result.hashCode();
            return n;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    protected String formatErrorMsg(String message) {
        return this.formatErrorMsg("error", message);
    }

    protected String formatErrorMsg(String type, String message) {
        StringBuffer buf = new StringBuffer();
        buf.append("<exist:result xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" ");
        buf.append("hitCount=\"0\">");
        buf.append('<');
        buf.append(type);
        buf.append('>');
        buf.append(message);
        buf.append("</");
        buf.append(type);
        buf.append("></exist:result>");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getCollectionDesc(User user, String rootCollection) throws Exception {
        DBBroker broker = this.brokerPool.get(user);
        Collection collection = null;
        try {
            if (rootCollection == null) {
                rootCollection = "/db";
            }
            if ((collection = broker.openCollection(rootCollection, 0)) == null) {
                throw new EXistException("collection " + rootCollection + " not found!");
            }
            Hashtable<String, Object> desc = new Hashtable<String, Object>();
            Vector docs = new Vector();
            Vector<String> collections = new Vector<String>();
            if (collection.getPermissions().validate(user, 4)) {
                Iterator i = collection.iterator(broker);
                while (i.hasNext()) {
                    DocumentImpl doc = (DocumentImpl)i.next();
                    Permission perms = doc.getPermissions();
                    Hashtable<String, Object> hash = new Hashtable<String, Object>(4);
                    hash.put("name", doc.getFileName());
                    hash.put("owner", perms.getOwner());
                    hash.put("group", perms.getOwnerGroup());
                    hash.put("permissions", new Integer(perms.getPermissions()));
                    hash.put("type", doc.getResourceType() == 1 ? "BinaryResource" : "XMLResource");
                    docs.addElement(hash);
                }
                i = collection.collectionIterator();
                while (i.hasNext()) {
                    collections.addElement((String)i.next());
                }
            }
            Permission perms = collection.getPermissions();
            desc.put("collections", collections);
            desc.put("documents", docs);
            desc.put("name", collection.getName());
            desc.put("created", Long.toString(collection.getCreationTime()));
            desc.put("owner", perms.getOwner());
            desc.put("group", perms.getOwnerGroup());
            desc.put("permissions", new Integer(perms.getPermissions()));
            Hashtable<String, Object> hashtable = desc;
            Object var13_12 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            return hashtable;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable describeResource(User user, String resourceName) throws EXistException, PermissionDeniedException {
        Hashtable<String, Object> hash;
        DocumentImpl doc;
        DBBroker broker;
        block7: {
            broker = this.brokerPool.get(user);
            doc = null;
            hash = new Hashtable<String, Object>(5);
            try {
                doc = broker.openDocument(resourceName, 0);
                if (doc != null) break block7;
                LOG.debug((Object)("document " + resourceName + " not found!"));
                Hashtable<String, Object> hashtable = hash;
                Object var9_8 = null;
                if (doc != null) {
                    doc.getUpdateLock().release(0);
                }
                this.brokerPool.release(broker);
                return hashtable;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (doc != null) {
                    doc.getUpdateLock().release(0);
                }
                this.brokerPool.release(broker);
                throw throwable;
            }
        }
        if (!doc.getCollection().getPermissions().validate(user, 4)) {
            throw new PermissionDeniedException("Not allowed to read collection");
        }
        Permission perms = doc.getPermissions();
        hash.put("name", resourceName);
        hash.put("owner", perms.getOwner());
        hash.put("group", perms.getOwnerGroup());
        hash.put("permissions", new Integer(perms.getPermissions()));
        hash.put("type", doc.getResourceType() == 1 ? "BinaryResource" : "XMLResource");
        hash.put("content-length", new Integer(doc.getContentLength()));
        Hashtable<String, Object> hashtable = hash;
        Object var9_9 = null;
        if (doc != null) {
            doc.getUpdateLock().release(0);
        }
        this.brokerPool.release(broker);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable describeCollection(User user, String rootCollection) throws Exception {
        DBBroker broker = this.brokerPool.get(user);
        Collection collection = null;
        try {
            if (rootCollection == null) {
                rootCollection = "/db";
            }
            if ((collection = broker.openCollection(rootCollection, 1)) == null) {
                throw new EXistException("collection " + rootCollection + " not found!");
            }
            Hashtable<String, Object> desc = new Hashtable<String, Object>();
            Vector<String> collections = new Vector<String>();
            if (collection.getPermissions().validate(user, 4)) {
                Iterator i = collection.collectionIterator();
                while (i.hasNext()) {
                    collections.addElement((String)i.next());
                }
            }
            Permission perms = collection.getPermissions();
            desc.put("collections", collections);
            desc.put("name", collection.getName());
            desc.put("created", Long.toString(collection.getCreationTime()));
            desc.put("owner", perms.getOwner());
            desc.put("group", perms.getOwnerGroup());
            desc.put("permissions", new Integer(perms.getPermissions()));
            Hashtable<String, Object> hashtable = desc;
            Object var10_9 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            return hashtable;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDocument(User user, String name, Hashtable parametri) throws Exception {
        String docName;
        DocumentImpl doc;
        Collection collection;
        DBBroker broker;
        block12: {
            long start = System.currentTimeMillis();
            broker = null;
            collection = null;
            doc = null;
            broker = this.brokerPool.get(user);
            int pos = name.lastIndexOf(47);
            String collName = name.substring(0, pos);
            docName = name.substring(pos + 1);
            collection = broker.openCollection(collName, 0);
            if (collection != null) break block12;
            LOG.debug((Object)("collection " + collName + " not found!"));
            String string = null;
            Object var16_14 = null;
            if (collection != null) {
                collection.releaseDocument(doc);
            }
            this.brokerPool.release(broker);
            return string;
        }
        try {
            String xml;
            if (!collection.getPermissions().validate(user, 4)) {
                collection.release();
                throw new PermissionDeniedException("Insufficient privileges to read resource");
            }
            doc = collection.getDocumentWithLock(broker, docName);
            collection.release();
            if (doc == null) {
                LOG.debug((Object)("document " + name + " not found!"));
                throw new EXistException("document not found");
            }
            if (!doc.getPermissions().validate(user, 4)) {
                throw new PermissionDeniedException("Insufficient privileges to read resource " + docName);
            }
            Serializer serializer = broker.getSerializer();
            serializer.setProperties(parametri);
            String string = xml = serializer.serialize(doc);
            Object var16_15 = null;
            if (collection != null) {
                collection.releaseDocument(doc);
            }
            this.brokerPool.release(broker);
            return string;
        }
        catch (NoSuchMethodError nsme) {
            try {
                nsme.printStackTrace();
                String string = null;
                Object var16_16 = null;
                if (collection != null) {
                    collection.releaseDocument(doc);
                }
                this.brokerPool.release(broker);
                return string;
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                if (collection != null) {
                    collection.releaseDocument(doc);
                }
                this.brokerPool.release(broker);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDocumentData(User user, String name, Hashtable parameters) throws Exception {
        Collection collection = null;
        DocumentImpl doc = null;
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            int pos = name.lastIndexOf(47);
            String collName = name.substring(0, pos);
            String docName = name.substring(pos + 1);
            collection = broker.openCollection(collName, 0);
            if (collection == null) {
                LOG.debug((Object)("collection " + collName + " not found!"));
                throw new EXistException("Collection " + collName + " not found!");
            }
            if (!collection.getPermissions().validate(user, 4)) {
                collection.release();
                throw new PermissionDeniedException("Insufficient privileges to read resource");
            }
            doc = collection.getDocumentWithLock(broker, docName);
            collection.release();
            if (doc == null) {
                LOG.debug((Object)("document " + name + " not found!"));
                throw new EXistException("document not found");
            }
            if (!doc.getPermissions().validate(user, 4)) {
                throw new PermissionDeniedException("Insufficient privileges to read resource " + docName);
            }
            String encoding = (String)parameters.get("encoding");
            if (encoding == null) {
                encoding = "UTF-8";
            }
            Serializer serializer = broker.getSerializer();
            serializer.setProperties(parameters);
            Hashtable<String, Object> result = new Hashtable<String, Object>();
            if (doc.getContentLength() > 262144) {
                File tempFile = File.createTempFile("eXist", ".xml");
                tempFile.deleteOnExit();
                LOG.debug((Object)("Writing to temporary file: " + tempFile.getName()));
                FileOutputStream os = new FileOutputStream(tempFile);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, encoding);
                serializer.serialize(doc, writer);
                ((Writer)writer).close();
                byte[] firstChunk = this.getChunk(tempFile, 0);
                result.put("data", firstChunk);
                result.put("handle", tempFile.getAbsolutePath());
                result.put("offset", new Integer(firstChunk.length));
            } else {
                String xml = serializer.serialize(doc);
                result.put("data", xml.getBytes(encoding));
                result.put("offset", new Integer(0));
            }
            Hashtable<String, Object> hashtable = result;
            Object var18_17 = null;
            if (collection != null) {
                collection.releaseDocument(doc);
            }
            this.brokerPool.release(broker);
            return hashtable;
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            if (collection != null) {
                collection.releaseDocument(doc);
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    public Hashtable getNextChunk(User user, String handle, int offset) throws Exception {
        File file = new File(handle);
        if (!file.isFile() || !file.canRead()) {
            throw new EXistException("Invalid handle specified");
        }
        if (offset <= 0 || (long)offset > file.length()) {
            throw new EXistException("No more data available");
        }
        byte[] chunk = this.getChunk(file, offset);
        int nextChunk = offset + chunk.length;
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("data", chunk);
        result.put("handle", handle);
        if ((long)nextChunk == file.length()) {
            file.delete();
            result.put("offset", new Integer(0));
        } else {
            result.put("offset", new Integer(nextChunk));
        }
        return result;
    }

    private byte[] getChunk(File file, int offset) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        raf.seek(offset);
        int remaining = (int)(raf.length() - (long)offset);
        if (remaining > 262144) {
            remaining = 262144;
        }
        byte[] data = new byte[remaining];
        raf.readFully(data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBinaryResource(User user, String name) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        DocumentImpl doc = null;
        try {
            broker = this.brokerPool.get(user);
            doc = broker.openDocument(name, 0);
            if (doc == null) {
                throw new EXistException("Resource " + name + " not found");
            }
            if (doc.getResourceType() != 1) {
                throw new EXistException("Document " + name + " is not a binary resource");
            }
            if (!doc.getPermissions().validate(user, 4)) {
                throw new PermissionDeniedException("Insufficient privileges to read resource");
            }
            byte[] byArray = broker.getBinaryResourceData((BinaryDocument)doc);
            Object var7_6 = null;
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.brokerPool.release(broker);
            return byArray;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    public int xupdate(User user, String collectionName, String xupdate) throws SAXException, LockException, PermissionDeniedException, EXistException, XPathException {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            Collection collection = broker.getCollection(collectionName);
            if (collection == null) {
                throw new EXistException("collection " + collectionName + " not found");
            }
            DocumentSet docs = collection.allDocs(broker, new DocumentSet(), true, true);
            XUpdateProcessor processor = new XUpdateProcessor(broker, docs);
            Modification[] modifications = processor.parse(new InputSource(new StringReader(xupdate)));
            long mods = 0L;
            for (int i = 0; i < modifications.length; ++i) {
                mods += modifications[i].process();
                broker.flush();
            }
            int n = (int)mods;
            return n;
        }
        catch (ParserConfigurationException e) {
            throw new EXistException(e.getMessage());
        }
        catch (IOException e) {
            throw new EXistException(e.getMessage());
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    public int xupdateResource(User user, String resource, String xupdate) throws SAXException, LockException, PermissionDeniedException, EXistException, XPathException {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            DocumentImpl doc = (DocumentImpl)broker.getDocument(resource);
            if (doc == null) {
                throw new EXistException("document " + resource + " not found");
            }
            if (!doc.getPermissions().validate(user, 4)) {
                throw new PermissionDeniedException("Insufficient privileges to read resource");
            }
            DocumentSet docs = new DocumentSet();
            docs.add(doc);
            XUpdateProcessor processor = new XUpdateProcessor(broker, docs);
            Modification[] modifications = processor.parse(new InputSource(new StringReader(xupdate)));
            long mods = 0L;
            for (int i = 0; i < modifications.length; ++i) {
                mods += modifications[i].process();
                broker.flush();
            }
            int n = (int)mods;
            return n;
        }
        catch (ParserConfigurationException e) {
            throw new EXistException(e.getMessage());
        }
        catch (IOException e) {
            throw new EXistException(e.getMessage());
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sync() {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get();
            broker.sync(1);
        }
        catch (EXistException eXistException) {
        }
        finally {
            this.brokerPool.release(broker);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDocumentListing(User user) throws EXistException {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            DocumentSet docs = broker.getAllDocuments(new DocumentSet());
            String[] names = docs.getNames();
            Vector<String> vec = new Vector<String>();
            for (int i = 0; i < names.length; ++i) {
                vec.addElement(names[i]);
            }
            Vector<String> vector = vec;
            return vector;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDocumentListing(User user, String name) throws EXistException, PermissionDeniedException {
        Vector<String> vec;
        Collection collection;
        DBBroker broker;
        block9: {
            broker = null;
            collection = null;
            broker = this.brokerPool.get(user);
            if (!name.startsWith("/")) {
                name = '/' + name;
            }
            if (!name.startsWith("/db")) {
                name = "/db" + name;
            }
            collection = broker.openCollection(name, 0);
            vec = new Vector<String>();
            if (collection != null) break block9;
            LOG.debug((Object)("collection " + name + " not found."));
            Vector<String> vector = vec;
            Object var10_8 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            return vector;
        }
        try {
            Iterator i = collection.iterator(broker);
            while (i.hasNext()) {
                String resource = ((DocumentImpl)i.next()).getFileName();
                int p = resource.lastIndexOf(47);
                vec.addElement(p < 0 ? resource : resource.substring(p + 1));
            }
            Vector<String> vector = vec;
            Object var10_9 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            return vector;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResourceCount(User user, String collectionName) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(user);
            if (!collectionName.startsWith("/")) {
                collectionName = '/' + collectionName;
            }
            if (!collectionName.startsWith("/db")) {
                collectionName = "/db" + collectionName;
            }
            collection = broker.openCollection(collectionName, 0);
            int n = collection.getDocumentCount();
            Object var7_6 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            return n;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createResourceId(User user, String collectionName) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            String id;
            boolean ok;
            broker = this.brokerPool.get(user);
            if (!collectionName.startsWith("/")) {
                collectionName = '/' + collectionName;
            }
            if (!collectionName.startsWith("/db")) {
                collectionName = "/db" + collectionName;
            }
            collection = broker.openCollection(collectionName, 0);
            Random rand = new Random();
            do {
                ok = true;
                id = Integer.toHexString(rand.nextInt()) + ".xml";
                if (collection.hasDocument(id)) {
                    ok = false;
                }
                if (!collection.hasSubcollection(id)) continue;
                ok = false;
            } while (!ok);
            String string = id;
            Object var10_9 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            return string;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable listDocumentPermissions(User user, String name) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(user);
            if (!name.startsWith("/")) {
                name = '/' + name;
            }
            if (!name.startsWith("/db")) {
                name = "/db" + name;
            }
            if ((collection = broker.openCollection(name, 0)) == null) {
                throw new EXistException("Collection " + name + " not found");
            }
            if (!collection.getPermissions().validate(user, 4)) {
                throw new PermissionDeniedException("not allowed to read collection " + name);
            }
            Hashtable result = new Hashtable(collection.getDocumentCount());
            Iterator i = collection.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl doc = (DocumentImpl)i.next();
                Permission perm = doc.getPermissions();
                Vector<Object> tmp = new Vector<Object>(3);
                tmp.addElement(perm.getOwner());
                tmp.addElement(perm.getOwnerGroup());
                tmp.addElement(new Integer(perm.getPermissions()));
                String docName = doc.getFileName();
                result.put(docName, tmp);
            }
            Hashtable hashtable = result;
            Object var12_11 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            return hashtable;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable listCollectionPermissions(User user, String name) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(user);
            if (!name.startsWith("/")) {
                name = '/' + name;
            }
            if (!name.startsWith("/db")) {
                name = "/db" + name;
            }
            if ((collection = broker.openCollection(name, 0)) == null) {
                throw new EXistException("Collection " + name + " not found");
            }
            if (!collection.getPermissions().validate(user, 4)) {
                throw new PermissionDeniedException("not allowed to read collection " + name);
            }
            Hashtable result = new Hashtable(collection.getChildCollectionCount());
            Iterator i = collection.collectionIterator();
            while (i.hasNext()) {
                String child = (String)i.next();
                String path = name + '/' + child;
                Collection childColl = broker.getCollection(path);
                Permission perm = childColl.getPermissions();
                Vector<Object> tmp = new Vector<Object>(3);
                tmp.addElement(perm.getOwner());
                tmp.addElement(perm.getOwnerGroup());
                tmp.addElement(new Integer(perm.getPermissions()));
                result.put(child, tmp);
            }
            Hashtable hashtable = result;
            Object var13_12 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            return hashtable;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    public int getHits(User user, int resultId) throws EXistException {
        QueryResult qr = (QueryResult)this.connectionPool.resultSets.get(resultId);
        if (qr == null) {
            throw new EXistException("result set unknown or timed out");
        }
        qr.timestamp = System.currentTimeMillis();
        if (qr.result == null) {
            return 0;
        }
        return qr.result.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getPermissions(User user, String name) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            if (!name.startsWith("/")) {
                name = '/' + name;
            }
            if (!name.startsWith("/db")) {
                name = "/db" + name;
            }
            Collection collection = broker.openCollection(name, 0);
            Permission perm = null;
            if (collection == null) {
                DocumentImpl doc = broker.openDocument(name, 0);
                if (doc == null) {
                    throw new EXistException("document or collection " + name + " not found");
                }
                perm = doc.getPermissions();
                doc.getUpdateLock().release(0);
            } else {
                perm = collection.getPermissions();
                collection.release();
            }
            Hashtable<String, Object> result = new Hashtable<String, Object>();
            result.put("owner", perm.getOwner());
            result.put("group", perm.getOwnerGroup());
            result.put("permissions", new Integer(perm.getPermissions()));
            Hashtable<String, Object> hashtable = result;
            return hashtable;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getCreationDate(User user, String collectionPath) throws PermissionDeniedException, EXistException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(user);
            if (!collectionPath.startsWith("/")) {
                collectionPath = '/' + collectionPath;
            }
            if (!collectionPath.startsWith("/db")) {
                collectionPath = "/db" + collectionPath;
            }
            if ((collection = broker.openCollection(collectionPath, 0)) == null) {
                throw new EXistException("collection " + collectionPath + " not found");
            }
            Date date = new Date(collection.getCreationTime());
            Object var7_6 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            return date;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getTimestamps(User user, String documentPath) throws PermissionDeniedException, EXistException {
        DBBroker broker = null;
        DocumentImpl doc = null;
        try {
            broker = this.brokerPool.get(user);
            if (!documentPath.startsWith("/")) {
                documentPath = '/' + documentPath;
            }
            if (!documentPath.startsWith("/db")) {
                documentPath = "/db" + documentPath;
            }
            if ((doc = broker.openDocument(documentPath, 0)) == null) {
                LOG.debug((Object)("document " + documentPath + " not found!"));
                throw new EXistException("document not found");
            }
            Vector<Date> vector = new Vector<Date>(2);
            vector.addElement(new Date(doc.getCreated()));
            vector.addElement(new Date(doc.getLastModified()));
            Vector<Date> vector2 = vector;
            Object var8_7 = null;
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.brokerPool.release(broker);
            return vector2;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    public Hashtable getUser(User user, String name) throws EXistException, PermissionDeniedException {
        User u = this.brokerPool.getSecurityManager().getUser(name);
        if (u == null) {
            throw new EXistException("user " + name + " does not exist");
        }
        Hashtable<String, Object> tab = new Hashtable<String, Object>();
        tab.put("name", u.getName());
        Vector groups = new Vector();
        Iterator i = u.getGroups();
        while (i.hasNext()) {
            groups.addElement(i.next());
        }
        tab.put("groups", groups);
        if (u.getHome() != null) {
            tab.put("home", u.getHome());
        }
        return tab;
    }

    public Vector getUsers(User user) throws EXistException, PermissionDeniedException {
        User[] users = this.brokerPool.getSecurityManager().getUsers();
        Vector r = new Vector();
        for (int i = 0; i < users.length; ++i) {
            Hashtable<String, Object> tab = new Hashtable<String, Object>();
            tab.put("name", users[i].getName());
            Vector groups = new Vector();
            Iterator j = users[i].getGroups();
            while (j.hasNext()) {
                groups.addElement(j.next());
            }
            tab.put("groups", groups);
            if (users[i].getHome() != null) {
                tab.put("home", users[i].getHome());
            }
            r.addElement(tab);
        }
        return r;
    }

    public Vector getGroups(User user) throws EXistException, PermissionDeniedException {
        String[] groups = this.brokerPool.getSecurityManager().getGroups();
        Vector<String> v = new Vector<String>(groups.length);
        for (int i = 0; i < groups.length; ++i) {
            v.addElement(groups[i]);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDocument(User user, String name) throws Exception {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            boolean bl = broker.getDocument(name) != null;
            return bl;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean parse(User user, byte[] xml, String path, boolean replace) throws Exception {
        DBBroker broker = null;
        Collection collection = null;
        try {
            void var12_14;
            void var13_15;
            long startTime = System.currentTimeMillis();
            broker = this.brokerPool.get(user);
            int p = path.lastIndexOf(47);
            if (p < 0 || p == path.length() - 1) {
                throw new EXistException("Illegal document path");
            }
            String collectionName = path.substring(0, p);
            String docName = path.substring(p + 1);
            try {
                DocumentImpl old;
                collection = broker.openCollection(collectionName, 1);
                if (collection == null) {
                    throw new EXistException("Collection " + collectionName + " not found");
                }
                if (!replace && (old = collection.getDocument(broker, docName)) != null) {
                    throw new PermissionDeniedException("Document exists and overwrite is not allowed");
                }
                ByteArrayInputStream is = new ByteArrayInputStream(xml);
                InputSource source = new InputSource(is);
                IndexInfo info = collection.validate(broker, docName, source);
            }
            finally {
                if (collection != null) {
                    collection.release();
                }
            }
            collection.store(broker, (IndexInfo)var13_15, (InputSource)var12_14, false);
            LOG.debug((Object)("parsing " + path + " took " + (System.currentTimeMillis() - startTime) + "ms."));
            this.documentCache.clear();
            boolean bl = true;
            this.brokerPool.release(broker);
            return bl;
        }
        catch (Exception e) {
            try {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.brokerPool.release(broker);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean parseLocal(User user, String localFile, String docName, boolean replace) throws EXistException, PermissionDeniedException, LockException, SAXException, TriggerException {
        File file = new File(localFile);
        if (!file.canRead()) {
            throw new EXistException("unable to read file " + localFile);
        }
        DBBroker broker = null;
        Object doc = null;
        try {
            void var12_12;
            void var11_13;
            broker = this.brokerPool.get(user);
            int p = docName.lastIndexOf(47);
            if (p < 0 || p == docName.length() - 1) {
                throw new EXistException("Illegal document path");
            }
            String collectionName = docName.substring(0, p);
            docName = docName.substring(p + 1);
            Collection collection = null;
            try {
                DocumentImpl old;
                collection = broker.openCollection(collectionName, 1);
                if (collection == null) {
                    throw new EXistException("Collection " + collectionName + " not found");
                }
                if (!replace && (old = collection.getDocument(broker, docName)) != null) {
                    throw new PermissionDeniedException("Old document exists and overwrite is not allowed");
                }
                InputSource source = new InputSource(file.toURI().toASCIIString());
                IndexInfo info = collection.validate(broker, docName, source);
            }
            finally {
                if (collection != null) {
                    collection.release();
                }
            }
            collection.store(broker, (IndexInfo)var11_13, (InputSource)var12_12, false);
        }
        finally {
            this.brokerPool.release(broker);
        }
        file.delete();
        this.documentCache.clear();
        return doc != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeBinary(User user, byte[] data, String docName, boolean replace) throws EXistException, PermissionDeniedException, LockException {
        DBBroker broker = null;
        BinaryDocument doc = null;
        Collection collection = null;
        try {
            DocumentImpl old;
            broker = this.brokerPool.get(user);
            int p = docName.lastIndexOf(47);
            if (p < 0 || p == docName.length() - 1) {
                throw new EXistException("Illegal document path");
            }
            String collectionName = docName.substring(0, p);
            docName = docName.substring(p + 1);
            collection = broker.openCollection(collectionName, 1);
            if (collection == null) {
                throw new EXistException("Collection " + collectionName + " not found");
            }
            if (!replace && (old = collection.getDocument(broker, docName)) != null) {
                throw new PermissionDeniedException("Old document exists and overwrite is not allowed");
            }
            LOG.debug((Object)("Storing binary resource to collection " + collection.getName()));
            doc = collection.addBinaryResource(broker, docName, data);
            Object var12_11 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
        this.documentCache.clear();
        return doc != null;
    }

    public String upload(User user, byte[] chunk, int length, String fileName) throws EXistException, IOException {
        File file;
        if (fileName == null || fileName.length() == 0) {
            file = File.createTempFile("rpc", "xml");
            fileName = file.getAbsolutePath();
            LOG.debug((Object)("created temporary file " + file.getAbsolutePath()));
        } else {
            LOG.debug((Object)("appending to file " + fileName));
            file = new File(fileName);
        }
        if (!file.canWrite()) {
            throw new EXistException("cannot write to file " + fileName);
        }
        FileOutputStream os = new FileOutputStream(file.getAbsolutePath(), true);
        os.write(chunk, 0, length);
        os.close();
        return fileName;
    }

    protected String printAll(DBBroker broker, Sequence resultSet, int howmany, int start, Hashtable properties, long queryTime) throws Exception {
        if (resultSet.getLength() == 0) {
            return "<?xml version=\"1.0\"?>\n<exist:result xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" hitCount=\"0\"/>";
        }
        if (howmany > resultSet.getLength() || howmany == 0) {
            howmany = resultSet.getLength();
        }
        if (start < 1 || start > resultSet.getLength()) {
            throw new EXistException("start parameter out of range");
        }
        StringWriter writer = new StringWriter();
        writer.write("<exist:result xmlns:exist=\"");
        writer.write(EXIST_NS);
        writer.write("\" hits=\"");
        writer.write(Integer.toString(resultSet.getLength()));
        writer.write("\" start=\"");
        writer.write(Integer.toString(start));
        writer.write("\" count=\"");
        writer.write(Integer.toString(howmany));
        writer.write("\">\n");
        Serializer serializer = broker.getSerializer();
        serializer.reset();
        serializer.setProperties(properties);
        for (int i = --start; i < start + howmany; ++i) {
            Item item = resultSet.itemAt(i);
            if (item == null) continue;
            if (item.getType() == 1) {
                NodeValue node = (NodeValue)item;
                writer.write(serializer.serialize(node));
                continue;
            }
            writer.write("<exist:value type=\"");
            writer.write(Type.getTypeName(item.getType()));
            writer.write("\">");
            writer.write(item.getStringValue());
            writer.write("</exist:value>");
        }
        writer.write("\n</exist:result>");
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String query(User user, String xpath, int howmany, int start, Hashtable parameters) throws Exception {
        String result;
        long startTime = System.currentTimeMillis();
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            QueryResult qr = this.doQuery(user, broker, xpath, null, parameters);
            if (qr.hasErrors()) {
                throw qr.getException();
            }
            if (qr == null) {
                String string = "<?xml version=\"1.0\"?>\n<exist:result xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" hitCount=\"0\"/>";
                return string;
            }
            result = this.printAll(broker, qr.result, howmany, start, parameters, System.currentTimeMillis() - startTime);
        }
        finally {
            this.brokerPool.release(broker);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable queryP(User user, String xpath, String docName, String s_id, Hashtable parameters) throws Exception {
        QueryResult queryResult;
        long startTime = System.currentTimeMillis();
        String sortBy = (String)parameters.get("sort-expr");
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        Vector<Object> result = new Vector<Object>();
        ArraySet nodes = null;
        Sequence resultSeq = null;
        DBBroker broker = null;
        try {
            Cloneable docs;
            Object doc;
            broker = this.brokerPool.get(user);
            if (docName != null && s_id != null) {
                if (!this.documentCache.containsKey(docName)) {
                    doc = (DocumentImpl)broker.getDocument(docName);
                    this.documentCache.put(docName, doc);
                } else {
                    doc = (DocumentImpl)this.documentCache.get(docName);
                }
                docs = new Vector<String>(1);
                docs.addElement(docName);
                parameters.put("static-documents", docs);
                if (s_id.length() > 0) {
                    long id = Long.parseLong(s_id);
                    NodeProxy node = new NodeProxy((DocumentImpl)doc, id);
                    nodes = new ArraySet(1);
                    nodes.add(node);
                }
            }
            if ((queryResult = this.doQuery(user, broker, xpath, nodes, parameters)) == null) {
                doc = ret;
                return doc;
            }
            if (queryResult.hasErrors()) {
                XPathException e = queryResult.getException();
                ret.put("error", e.getMessage());
                if (e.getLine() != 0) {
                    ret.put("line", new Integer(e.getLine()));
                    ret.put("column", new Integer(e.getColumn()));
                }
                docs = ret;
                return docs;
            }
            resultSeq = queryResult.result;
            LOG.debug((Object)("found " + resultSeq.getLength()));
            if (sortBy != null) {
                SortedNodeSet sorted = new SortedNodeSet(this.brokerPool, user, sortBy);
                sorted.addAll(resultSeq);
                resultSeq = sorted;
            }
            if (resultSeq != null) {
                SequenceIterator i = resultSeq.iterate();
                if (i != null) {
                    while (i.hasNext()) {
                        Item next = i.nextItem();
                        if (Type.subTypeOf(next.getType(), -1)) {
                            Vector<String> entry = new Vector<String>();
                            if (((NodeValue)next).getImplementationType() == 1) {
                                NodeProxy p = (NodeProxy)next;
                                entry.addElement(p.getDoc().getCollection().getName() + '/' + p.getDoc().getFileName());
                                entry.addElement(Long.toString(p.getGID()));
                            } else {
                                entry.addElement("temp_xquery/" + next.hashCode());
                                entry.addElement(String.valueOf(((NodeImpl)next).getNodeNumber()));
                            }
                            result.addElement(entry);
                            continue;
                        }
                        result.addElement(next.getStringValue());
                    }
                } else {
                    LOG.debug((Object)"sequence iterator is null. Should not");
                }
            } else {
                LOG.debug((Object)"result sequence is null. Skipping it...");
            }
        }
        finally {
            this.brokerPool.release(broker);
        }
        queryResult.result = resultSeq;
        queryResult.queryTime = System.currentTimeMillis() - startTime;
        this.connectionPool.resultSets.put(queryResult.hashCode(), queryResult);
        ret.put("id", new Integer(queryResult.hashCode()));
        ret.put("results", result);
        return ret;
    }

    public void releaseQueryResult(int handle) {
        this.connectionPool.resultSets.remove(handle);
        this.documentCache.clear();
        LOG.debug((Object)("removed query result with handle " + handle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(User user, String docPath) throws Exception {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(user);
            int p = docPath.lastIndexOf(47);
            if (p < 0 || p == docPath.length() - 1) {
                throw new EXistException("Illegal document path");
            }
            String collectionName = docPath.substring(0, p);
            String docName = docPath.substring(p + 1);
            collection = broker.openCollection(collectionName, 1);
            if (collection == null) {
                throw new EXistException("Collection " + collectionName + " not found");
            }
            DocumentImpl doc = collection.getDocument(broker, docName);
            if (doc == null) {
                throw new EXistException("Document " + docPath + " not found");
            }
            if (doc.getResourceType() == 1) {
                collection.removeBinaryResource(broker, doc);
            } else {
                collection.removeDocument(broker, docName);
            }
            this.documentCache.clear();
            Object var10_9 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCollection(User user, String name) throws Exception {
        Collection collection;
        DBBroker broker;
        block6: {
            broker = null;
            collection = null;
            try {
                broker = this.brokerPool.get(user);
                collection = broker.openCollection(name, 1);
                if (collection != null) break block6;
                boolean bl = false;
                Object var7_7 = null;
                if (collection != null) {
                    collection.getLock().release();
                }
                this.brokerPool.release(broker);
                return bl;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (collection != null) {
                    collection.getLock().release();
                }
                this.brokerPool.release(broker);
                throw throwable;
            }
        }
        LOG.debug((Object)("removing collection " + name));
        this.documentCache.clear();
        boolean bl = broker.removeCollection(collection);
        Object var7_8 = null;
        if (collection != null) {
            collection.getLock().release();
        }
        this.brokerPool.release(broker);
        return bl;
    }

    public boolean removeUser(User user, String name) throws EXistException, PermissionDeniedException {
        SecurityManager manager = this.brokerPool.getSecurityManager();
        if (!manager.hasAdminPrivileges(user)) {
            throw new PermissionDeniedException("you are not allowed to remove users");
        }
        manager.deleteUser(name);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retrieve(User user, String docName, String s_id, Hashtable parameters) throws Exception {
        DBBroker broker = this.brokerPool.get(user);
        try {
            DocumentImpl doc;
            long id = Long.parseLong(s_id);
            if (!this.documentCache.containsKey(docName)) {
                LOG.debug((Object)("loading doc " + docName));
                doc = (DocumentImpl)broker.getDocument(docName);
                this.documentCache.put(docName, doc);
            } else {
                doc = (DocumentImpl)this.documentCache.get(docName);
            }
            NodeProxy node = new NodeProxy(doc, id);
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            serializer.setProperties(parameters);
            String string = serializer.serialize(node);
            return string;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retrieve(User user, int resultId, int num, Hashtable parameters) throws Exception {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            QueryResult qr = (QueryResult)this.connectionPool.resultSets.get(resultId);
            if (qr == null) {
                throw new EXistException("result set unknown or timed out");
            }
            qr.timestamp = System.currentTimeMillis();
            Item item = qr.result.itemAt(num);
            if (item == null) {
                throw new EXistException("index out of range");
            }
            if (Type.subTypeOf(item.getType(), -1)) {
                NodeValue nodeValue = (NodeValue)item;
                Serializer serializer = broker.getSerializer();
                serializer.reset();
                this.checkPragmas(qr.context, parameters);
                serializer.setProperties(parameters);
                String string = serializer.serialize(nodeValue);
                return string;
            }
            String string = item.getStringValue();
            return string;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retrieveAll(User user, int resultId, Hashtable parameters) throws Exception {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            QueryResult qr = (QueryResult)this.connectionPool.resultSets.get(resultId);
            if (qr == null) {
                throw new EXistException("result set unknown or timed out");
            }
            qr.timestamp = System.currentTimeMillis();
            this.checkPragmas(qr.context, parameters);
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            serializer.setProperties(parameters);
            SAXSerializer handler = SAXSerializerPool.getInstance().borrowSAXSerializer();
            handler.setOutputProperties(this.getProperties(parameters));
            StringWriter writer = new StringWriter();
            handler.setWriter(writer);
            handler.startDocument();
            handler.startPrefixMapping("exist", EXIST_NS);
            AttributesImpl attribs = new AttributesImpl();
            attribs.addAttribute("", "hitCount", "hitCount", "CDATA", Integer.toString(qr.result.getLength()));
            handler.startElement(EXIST_NS, "result", "exist:result", attribs);
            SequenceIterator i = qr.result.iterate();
            while (i.hasNext()) {
                Item current = i.nextItem();
                if (Type.subTypeOf(current.getType(), -1)) {
                    ((NodeValue)current).toSAX(broker, handler);
                    continue;
                }
                char[] value = current.toString().toCharArray();
                handler.characters(value, 0, value.length);
            }
            handler.endElement(EXIST_NS, "result", "exist:result");
            handler.endPrefixMapping("exist");
            handler.endDocument();
            String string = writer.toString();
            return string;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RpcConnection rpcConnection = this;
        synchronized (rpcConnection) {
            while (!this.terminate) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setPermissions(User user, String resource, String owner, String ownerGroup, String permissions) throws EXistException, PermissionDeniedException {
        boolean bl;
        DBBroker broker = null;
        Collection collection = null;
        DocumentImpl doc = null;
        try {
            try {
                broker = this.brokerPool.get(user);
                SecurityManager manager = this.brokerPool.getSecurityManager();
                collection = broker.openCollection(resource, 1);
                if (collection == null) {
                    doc = broker.openDocument(resource, 1);
                    if (doc == null) {
                        throw new EXistException("document or collection " + resource + " not found");
                    }
                    LOG.debug((Object)("changing permissions on document " + resource));
                    Permission perm = doc.getPermissions();
                    if (!perm.getOwner().equals(user.getName())) {
                        if (!manager.hasAdminPrivileges(user)) throw new PermissionDeniedException("not allowed to change permissions");
                    }
                    if (owner != null) {
                        perm.setOwner(owner);
                        perm.setGroup(ownerGroup);
                    }
                    if (permissions != null && permissions.length() > 0) {
                        perm.setPermissions(permissions);
                    }
                    broker.saveCollection(doc.getCollection());
                    broker.flush();
                    boolean bl2 = true;
                    Object var13_16 = null;
                    if (doc != null) {
                        doc.getUpdateLock().release(1);
                    }
                    if (collection != null) {
                        collection.release();
                    }
                    this.brokerPool.release(broker);
                    return bl2;
                }
                LOG.debug((Object)("changing permissions on collection " + resource));
                Permission perm = collection.getPermissions();
                if (!perm.getOwner().equals(user.getName())) {
                    if (!manager.hasAdminPrivileges(user)) throw new PermissionDeniedException("not allowed to change permissions");
                }
                if (permissions != null) {
                    perm.setPermissions(permissions);
                }
                if (owner != null) {
                    perm.setOwner(owner);
                    perm.setGroup(ownerGroup);
                }
                broker.saveCollection(collection);
                broker.flush();
                bl = true;
            }
            catch (SyntaxException e) {
                throw new EXistException(e.getMessage());
            }
            catch (PermissionDeniedException e) {
                throw new EXistException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
        Object var13_17 = null;
        if (doc != null) {
            doc.getUpdateLock().release(1);
        }
        if (collection != null) {
            collection.release();
        }
        this.brokerPool.release(broker);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setPermissions(User user, String resource, String owner, String ownerGroup, int permissions) throws EXistException, PermissionDeniedException {
        boolean bl;
        DBBroker broker = null;
        Collection collection = null;
        DocumentImpl doc = null;
        try {
            try {
                broker = this.brokerPool.get(user);
                SecurityManager manager = this.brokerPool.getSecurityManager();
                collection = broker.openCollection(resource, 1);
                if (collection == null) {
                    doc = broker.openDocument(resource, 1);
                    if (doc == null) {
                        throw new EXistException("document or collection " + resource + " not found");
                    }
                    LOG.debug((Object)("changing permissions on document " + resource));
                    Permission perm = doc.getPermissions();
                    if (!perm.getOwner().equals(user.getName())) {
                        if (!manager.hasAdminPrivileges(user)) throw new PermissionDeniedException("not allowed to change permissions");
                    }
                    if (owner != null) {
                        perm.setOwner(owner);
                        perm.setGroup(ownerGroup);
                    }
                    perm.setPermissions(permissions);
                    broker.saveCollection(doc.getCollection());
                    broker.flush();
                    boolean bl2 = true;
                    Object var13_15 = null;
                    if (doc != null) {
                        doc.getUpdateLock().release(1);
                    }
                    if (collection != null) {
                        collection.release();
                    }
                    this.brokerPool.release(broker);
                    return bl2;
                }
                LOG.debug((Object)("changing permissions on collection " + resource));
                Permission perm = collection.getPermissions();
                if (!perm.getOwner().equals(user.getName())) {
                    if (!manager.hasAdminPrivileges(user)) throw new PermissionDeniedException("not allowed to change permissions");
                }
                perm.setPermissions(permissions);
                if (owner != null) {
                    perm.setOwner(owner);
                    perm.setGroup(ownerGroup);
                }
                broker.saveCollection(collection);
                broker.flush();
                bl = true;
            }
            catch (PermissionDeniedException e) {
                throw new EXistException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
        Object var13_16 = null;
        if (doc != null) {
            doc.getUpdateLock().release(1);
        }
        if (collection != null) {
            collection.release();
        }
        this.brokerPool.release(broker);
        return bl;
    }

    public boolean setUser(User user, String name, String passwd, Vector groups, String home) throws EXistException, PermissionDeniedException {
        User u;
        SecurityManager manager = this.brokerPool.getSecurityManager();
        if (name.equals("guest") && !manager.hasAdminPrivileges(user)) {
            throw new PermissionDeniedException("guest user cannot be modified");
        }
        if (!manager.hasUser(name)) {
            if (!manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("not allowed to create user");
            }
            u = new User(name);
            u.setPasswordDigest(passwd);
        } else {
            u = manager.getUser(name);
            if (!u.getName().equals(user.getName()) && !manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("you are not allowed to change this user");
            }
            u.setPasswordDigest(passwd);
        }
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            String g = (String)i.next();
            if (u.hasGroup(g)) continue;
            if (!manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("User is not allowed to add groups");
            }
            u.addGroup(g);
        }
        if (home != null) {
            u.setHome(home);
        }
        manager.setUser(u);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockResource(User user, String path, String userName) throws Exception {
        DBBroker broker = null;
        DocumentImpl doc = null;
        try {
            broker = this.brokerPool.get(user);
            doc = broker.openDocument(path, 1);
            if (doc == null) {
                throw new EXistException("Resource " + path + " not found");
            }
            if (!doc.getPermissions().validate(user, 1)) {
                throw new PermissionDeniedException("User is not allowed to lock resource " + path);
            }
            SecurityManager manager = this.brokerPool.getSecurityManager();
            if (!userName.equals(user.getName()) && !manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("User " + user.getName() + " is not allowed " + "to lock the resource for user " + userName);
            }
            User lockOwner = doc.getUserLock();
            if (lockOwner != null && !lockOwner.equals(user) && !manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("Resource is already locked by user " + lockOwner.getName());
            }
            doc.setUserLock(user);
            broker.saveCollection(doc.getCollection());
            boolean bl = true;
            Object var10_9 = null;
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.brokerPool.release(broker);
            return bl;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hasUserLock(User user, String path) throws Exception {
        DBBroker broker = null;
        DocumentImpl doc = null;
        try {
            broker = this.brokerPool.get(user);
            doc = broker.openDocument(path, 0);
            if (!doc.getPermissions().validate(user, 4)) {
                throw new PermissionDeniedException("Insufficient privileges to read resource");
            }
            if (doc == null) {
                throw new EXistException("Resource " + path + " not found");
            }
            User u = doc.getUserLock();
            String string = u == null ? "" : u.getName();
            Object var8_7 = null;
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.brokerPool.release(broker);
            return string;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlockResource(User user, String path) throws Exception {
        DBBroker broker = null;
        DocumentImpl doc = null;
        try {
            broker = this.brokerPool.get(user);
            doc = broker.openDocument(path, 1);
            if (doc == null) {
                throw new EXistException("Resource " + path + " not found");
            }
            if (!doc.getPermissions().validate(user, 1)) {
                throw new PermissionDeniedException("User is not allowed to lock resource " + path);
            }
            SecurityManager manager = this.brokerPool.getSecurityManager();
            User lockOwner = doc.getUserLock();
            if (lockOwner != null && !lockOwner.equals(user) && !manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("Resource is already locked by user " + lockOwner.getName());
            }
            doc.setUserLock(null);
            broker.saveCollection(doc.getCollection());
            boolean bl = true;
            Object var9_8 = null;
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.brokerPool.release(broker);
            return bl;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable summary(User user, String xpath) throws Exception {
        long startTime = System.currentTimeMillis();
        DBBroker broker = null;
        try {
            NodeCount counter;
            broker = this.brokerPool.get(user);
            QueryResult qr = this.doQuery(user, broker, xpath, null, null);
            if (qr == null) {
                Hashtable hashtable = new Hashtable();
                return hashtable;
            }
            if (qr.hasErrors()) {
                throw qr.getException();
            }
            NodeList resultSet = (NodeList)((Object)qr.result);
            HashMap<String, NodeCount> map = new HashMap<String, NodeCount>();
            HashMap<String, DoctypeCount> doctypes = new HashMap<String, DoctypeCount>();
            Iterator i = ((NodeSet)resultSet).iterator();
            while (i.hasNext()) {
                DoctypeCount doctypeCounter;
                NodeProxy p = (NodeProxy)i.next();
                String docName = p.getDoc().getCollection().getName() + '/' + p.getDoc().getFileName();
                DocumentType doctype = p.getDoc().getDoctype();
                if (map.containsKey(docName)) {
                    counter = (NodeCount)map.get(docName);
                    counter.inc();
                } else {
                    counter = new NodeCount(p.getDoc());
                    map.put(docName, counter);
                }
                if (doctype == null) continue;
                if (doctypes.containsKey(doctype.getName())) {
                    doctypeCounter = (DoctypeCount)doctypes.get(doctype.getName());
                    doctypeCounter.inc();
                    continue;
                }
                doctypeCounter = new DoctypeCount(doctype);
                doctypes.put(doctype.getName(), doctypeCounter);
            }
            Hashtable<String, Serializable> result = new Hashtable<String, Serializable>();
            result.put("queryTime", new Integer((int)(System.currentTimeMillis() - startTime)));
            result.put("hits", new Integer(resultSet.getLength()));
            Vector documents = new Vector();
            Iterator i2 = map.values().iterator();
            while (i2.hasNext()) {
                counter = (NodeCount)i2.next();
                Vector<Object> hitsByDoc = new Vector<Object>();
                hitsByDoc.addElement(counter.doc.getFileName());
                hitsByDoc.addElement(new Integer(counter.doc.getDocId()));
                hitsByDoc.addElement(new Integer(counter.count));
                documents.addElement(hitsByDoc);
            }
            result.put("documents", documents);
            Vector dtypes = new Vector();
            Iterator i3 = doctypes.values().iterator();
            while (i3.hasNext()) {
                DoctypeCount docTemp = (DoctypeCount)i3.next();
                Vector<Object> hitsByType = new Vector<Object>();
                hitsByType.addElement(docTemp.doctype.getName());
                hitsByType.addElement(new Integer(docTemp.count));
                dtypes.addElement(hitsByType);
            }
            result.put("doctypes", dtypes);
            Hashtable<String, Serializable> hashtable = result;
            return hashtable;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable summary(User user, int resultId) throws EXistException {
        long startTime = System.currentTimeMillis();
        QueryResult qr = (QueryResult)this.connectionPool.resultSets.get(resultId);
        if (qr == null) {
            throw new EXistException("result set unknown or timed out");
        }
        qr.timestamp = System.currentTimeMillis();
        Hashtable<String, Serializable> result = new Hashtable<String, Serializable>();
        result.put("queryTime", new Integer((int)qr.queryTime));
        if (qr.result == null) {
            result.put("hits", new Integer(0));
            return result;
        }
        DBBroker broker = this.brokerPool.get(user);
        try {
            NodeCount counter;
            NodeList resultSet = (NodeList)((Object)qr.result);
            HashMap<String, NodeCount> map = new HashMap<String, NodeCount>();
            HashMap<String, DoctypeCount> doctypes = new HashMap<String, DoctypeCount>();
            Iterator i = ((NodeSet)resultSet).iterator();
            while (i.hasNext()) {
                DoctypeCount doctypeCounter;
                NodeProxy p = (NodeProxy)i.next();
                String docName = p.getDoc().getCollection().getName() + '/' + p.getDoc().getFileName();
                DocumentType doctype = p.getDoc().getDoctype();
                if (map.containsKey(docName)) {
                    counter = (NodeCount)map.get(docName);
                    counter.inc();
                } else {
                    counter = new NodeCount(p.getDoc());
                    map.put(docName, counter);
                }
                if (doctype == null) continue;
                if (doctypes.containsKey(doctype.getName())) {
                    doctypeCounter = (DoctypeCount)doctypes.get(doctype.getName());
                    doctypeCounter.inc();
                    continue;
                }
                doctypeCounter = new DoctypeCount(doctype);
                doctypes.put(doctype.getName(), doctypeCounter);
            }
            result.put("hits", new Integer(resultSet.getLength()));
            Vector documents = new Vector();
            Iterator i2 = map.values().iterator();
            while (i2.hasNext()) {
                counter = (NodeCount)i2.next();
                Vector<Object> hitsByDoc = new Vector<Object>();
                hitsByDoc.addElement(counter.doc.getFileName());
                hitsByDoc.addElement(new Integer(counter.doc.getDocId()));
                hitsByDoc.addElement(new Integer(counter.count));
                documents.addElement(hitsByDoc);
            }
            result.put("documents", documents);
            Vector dtypes = new Vector();
            Iterator i3 = doctypes.values().iterator();
            while (i3.hasNext()) {
                DoctypeCount docTemp = (DoctypeCount)i3.next();
                Vector<Object> hitsByType = new Vector<Object>();
                hitsByType.addElement(docTemp.doctype.getName());
                hitsByType.addElement(new Integer(docTemp.count));
                dtypes.addElement(hitsByType);
            }
            result.put("doctypes", dtypes);
            Hashtable<String, Serializable> hashtable = result;
            return hashtable;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getIndexedElements(User user, String collectionName, boolean inclusive) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(user);
            collection = broker.openCollection(collectionName, 0);
            if (collection == null) {
                throw new EXistException("collection " + collectionName + " not found");
            }
            Occurrences[] occurrences = broker.getElementIndex().scanIndexedElements(collection, inclusive);
            Vector result = new Vector(occurrences.length);
            for (int i = 0; i < occurrences.length; ++i) {
                QName qname = (QName)occurrences[i].getTerm();
                Vector<Object> temp = new Vector<Object>(4);
                temp.addElement(qname.getLocalName());
                temp.addElement(qname.getNamespaceURI());
                temp.addElement(qname.getPrefix() == null ? "" : qname.getPrefix());
                temp.addElement(new Integer(occurrences[i].getOccurrences()));
                result.addElement(temp);
            }
            Vector vector = result;
            Object var12_12 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            return vector;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector scanIndexTerms(User user, String collectionName, String start, String end, boolean inclusive) throws PermissionDeniedException, EXistException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(user);
            collection = broker.openCollection(collectionName, 0);
            if (collection == null) {
                throw new EXistException("collection " + collectionName + " not found");
            }
            Occurrences[] occurrences = broker.getTextEngine().scanIndexTerms(user, collection, start, end, inclusive);
            Vector result = new Vector(occurrences.length);
            for (int i = 0; i < occurrences.length; ++i) {
                Vector<Object> temp = new Vector<Object>(2);
                temp.addElement(occurrences[i].getTerm().toString());
                temp.addElement(new Integer(occurrences[i].getOccurrences()));
                result.addElement(temp);
            }
            Vector vector = result;
            Object var13_13 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            return vector;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    public void synchronize() {
        this.documentCache.clear();
    }

    public void terminate() {
        this.terminate = true;
    }

    private Properties getProperties(Hashtable parameters) {
        Properties properties = new Properties();
        Iterator i = parameters.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            properties.setProperty((String)entry.getKey(), entry.getValue().toString());
        }
        return properties;
    }

    private CachedQuery getCachedQuery(String query) {
        CachedQuery found = null;
        Iterator i = this.cachedExpressions.iterator();
        while (i.hasNext()) {
            CachedQuery cached = (CachedQuery)i.next();
            if (cached.queryString.equals(query)) {
                found = cached;
                found.expression.reset();
                cached.timestamp = System.currentTimeMillis();
                continue;
            }
            if (System.currentTimeMillis() - cached.timestamp <= 120000L) continue;
            LOG.debug((Object)"Releasing compiled expression");
            i.remove();
        }
        return found;
    }

    public byte[] getDocumentChunk(User user, String name, int start, int len) throws EXistException, PermissionDeniedException, IOException {
        File file = new File(System.getProperty("java.io.tmpdir") + File.separator + name);
        if (!file.canRead()) {
            throw new EXistException("unable to read file " + name);
        }
        if (file.length() < (long)(start + len)) {
            throw new EXistException("address too big " + name);
        }
        byte[] buffer = new byte[len];
        RandomAccessFile os = new RandomAccessFile(file.getAbsolutePath(), "r");
        LOG.debug((Object)("Read from: " + start + " to: " + (start + len)));
        os.seek(start);
        int reada = os.read(buffer);
        os.close();
        return buffer;
    }

    public boolean moveOrCopyResource(User user, String docPath, String destinationPath, String newName, boolean move) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        Collection destination = null;
        DocumentImpl doc = null;
        try {
            broker = this.brokerPool.get(user);
            int p = docPath.lastIndexOf(47);
            if (p < 0 || p == docPath.length() - 1) {
                throw new EXistException("Illegal document path");
            }
            String collectionName = docPath.substring(0, p);
            String docName = docPath.substring(p + 1);
            collection = broker.openCollection(collectionName, move ? 1 : 0);
            if (collection == null) {
                throw new EXistException("Collection " + collectionName + " not found");
            }
            doc = collection.getDocumentWithLock(broker, docName, 1);
            if (doc == null) {
                throw new EXistException("Document " + docPath + " not found");
            }
            destination = broker.openCollection(destinationPath, 1);
            if (destination == null) {
                throw new EXistException("Destination collection " + destinationPath + " not found");
            }
            if (move) {
                broker.moveResource(doc, destination, newName);
            } else {
                broker.copyResource(doc, destination, newName);
            }
            this.documentCache.clear();
            boolean bl = true;
            Object var15_15 = null;
            if (collection != null) {
                collection.release();
            }
            if (destination != null) {
                destination.release();
            }
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.brokerPool.release(broker);
            return bl;
        }
        catch (LockException e) {
            try {
                throw new PermissionDeniedException("Could not acquire lock on document " + docPath);
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                if (collection != null) {
                    collection.release();
                }
                if (destination != null) {
                    destination.release();
                }
                if (doc != null) {
                    doc.getUpdateLock().release(1);
                }
                this.brokerPool.release(broker);
                throw throwable;
            }
        }
    }

    public boolean moveOrCopyCollection(User user, String collectionPath, String destinationPath, String newName, boolean move) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        Collection destination = null;
        try {
            broker = this.brokerPool.get(user);
            collection = broker.openCollection(collectionPath, move ? 1 : 0);
            if (collection == null) {
                throw new EXistException("Collection " + collectionPath + " not found");
            }
            destination = broker.openCollection(destinationPath, 1);
            if (destination == null) {
                throw new EXistException("Destination collection " + destinationPath + " not found");
            }
            if (move) {
                broker.moveCollection(collection, destination, newName);
            } else {
                broker.copyCollection(collection, destination, newName);
            }
            this.documentCache.clear();
            boolean bl = true;
            Object var11_11 = null;
            if (collection != null) {
                collection.release();
            }
            if (destination != null) {
                destination.release();
            }
            this.brokerPool.release(broker);
            return bl;
        }
        catch (LockException e) {
            try {
                throw new PermissionDeniedException(e.getMessage());
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (collection != null) {
                    collection.release();
                }
                if (destination != null) {
                    destination.release();
                }
                this.brokerPool.release(broker);
                throw throwable;
            }
        }
    }

    public void reindexCollection(User user, String name) throws Exception, PermissionDeniedException {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            broker.reindex(name);
            LOG.debug((Object)("collection " + name + " and sub collection reindexed"));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
            throw e;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    class NodeCount {
        int count = 1;
        DocumentImpl doc;

        public NodeCount(DocumentImpl doc) {
            this.doc = doc;
        }

        public void inc() {
            ++this.count;
        }
    }

    class DoctypeCount {
        int count = 1;
        DocumentType doctype;

        public DoctypeCount(DocumentType doctype) {
            this.doctype = doctype;
        }

        public void inc() {
            ++this.count;
        }
    }

    class CachedQuery {
        PathExpr expression;
        String queryString;
        long timestamp;

        public CachedQuery(PathExpr expr, String query) {
            this.expression = expr;
            this.queryString = query;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

