/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.test.concurrent;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Random;

public class XMLGenerator {
    String[] words;
    int elementCnt;
    int attrCnt;
    int depth;
    Random random;

    public XMLGenerator(int elementCnt, int attrCnt, int depth, String[] words) {
        this.elementCnt = elementCnt;
        this.attrCnt = attrCnt;
        this.depth = depth;
        this.words = words;
        this.random = new Random(System.currentTimeMillis());
    }

    public void generateXML(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\"?>");
        writer.write("<ROOT-ELEMENT>");
        for (int i = 0; i < this.elementCnt; ++i) {
            this.writeElement(writer, 0);
        }
        writer.write("</ROOT-ELEMENT>");
    }

    public String generateElement() throws IOException {
        StringWriter writer = new StringWriter();
        this.writeElement(writer, 0);
        return writer.toString();
    }

    protected void writeElement(Writer writer, int level) throws IOException {
        writer.write("<ELEMENT");
        if (level > 0) {
            writer.write(45);
            writer.write(Integer.toString(level));
        }
        for (int i = 0; i < this.attrCnt; ++i) {
            writer.write(" attribute-");
            writer.write(Integer.toString(i));
            writer.write("=\"");
            writer.write(this.generateText(1));
            writer.write("\"");
        }
        writer.write(">\n");
        if (level < this.depth - 1) {
            this.writeElement(writer, level + 1);
        } else {
            writer.write(this.generateText(20));
        }
        writer.write("\n</ELEMENT");
        if (level > 0) {
            writer.write(45);
            writer.write(Integer.toString(level));
        }
        writer.write(">\n");
    }

    public String generateText(int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buf.append(' ');
            }
            int n = this.random.nextInt(this.words.length);
            buf.append(this.words[n]);
        }
        return buf.toString();
    }
}

