/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.test;

import java.io.File;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.exist.xmldb.test.concurrent.DBUtils;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;

public class ShutdownTest
extends TestCase {
    private static final String URI = "xmldb:exist:///db";
    protected static final String XML = "<config><user id=\"george\"><phone>+49 69 888478</phone><email>george@email.com</email><customer-id>64534233</customer-id><bank-account>7466356</bank-account></user><user id=\"sam\"><phone>+49 69 774345</phone><email>sam@email.com</email><customer-id>993834</customer-id><bank-account>364553</bank-account></user></config>";
    private static final String TEST_QUERY1 = "//user[@id = 'george']/phone[contains(., '69')]/text()";
    private static final String TEST_QUERY2 = "//user[@id = 'sam']/customer-id[. = '993834']";
    private static final String TEST_QUERY3 = "//user[email = 'sam@email.com']";
    private static final String TEST_QUERY4 = "/ROOT-ELEMENT/ELEMENT/ELEMENT-1";
    private String[] wordList;

    public ShutdownTest(String name) {
        super(name);
    }

    public void testShutdown() throws Exception {
        for (int i = 0; i < 50; ++i) {
            System.out.println("Starting the database ...");
            Collection rootCol = DBUtils.setupDB(URI);
            Collection testCol = rootCol.getChildCollection("C1");
            ResourceSet result = DBUtils.query(testCol, TEST_QUERY1);
            Assert.assertEquals((long)1L, (long)result.getSize());
            Assert.assertEquals((Object)"+49 69 888478", (Object)result.getResource(0L).getContent());
            result = DBUtils.query(testCol, TEST_QUERY2);
            Assert.assertEquals((long)1L, (long)result.getSize());
            result = DBUtils.query(testCol, TEST_QUERY3);
            Assert.assertEquals((long)1L, (long)result.getSize());
            result = DBUtils.query(testCol, TEST_QUERY4);
            Assert.assertEquals((long)5000L, (long)result.getSize());
            String xml = "<data now=\"" + System.currentTimeMillis() + "\" count=\"" + i + "\">" + XML + "</data>";
            System.out.println("Storing resource ...");
            DBUtils.addXMLResource(testCol, "R1.xml", xml);
            System.out.println("Storing large file ...");
            File tempFile = DBUtils.generateXMLFile(5000, 7, this.wordList);
            DBUtils.addXMLResource(testCol, "R2.xml", tempFile);
            System.out.println("Shut down the database ...");
            DBUtils.shutdownDB(URI);
        }
    }

    protected void setUp() throws Exception {
        Collection rootCol = DBUtils.setupDB(URI);
        Collection testCol = rootCol.getChildCollection("C1");
        if (testCol == null) {
            testCol = DBUtils.addCollection(rootCol, "C1");
            ShutdownTest.assertNotNull((Object)testCol);
        }
        DBUtils.addXMLResource(rootCol, "biblio.rdf", new File("samples/biblio.rdf"));
        this.wordList = DBUtils.wordList(rootCol);
        String xml = "<data now=\"" + System.currentTimeMillis() + "\" count=\"1\">" + XML + "</data>";
        DBUtils.addXMLResource(testCol, "R1.xml", xml);
        File tempFile = DBUtils.generateXMLFile(5000, 7, this.wordList);
        DBUtils.addXMLResource(testCol, "R2.xml", tempFile);
        DBUtils.shutdownDB(URI);
    }

    protected void tearDown() throws Exception {
        Collection rootCol = DBUtils.setupDB(URI);
        DBUtils.removeCollection(rootCol, "C1");
        Resource res = rootCol.getResource("biblio.rdf");
        rootCol.removeResource(res);
        DBUtils.shutdownDB(URI);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)ShutdownTest.class);
    }
}

