/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.test;

import junit.framework.TestCase;
import org.exist.xmldb.ResourceSetHelper;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XPathQueryService;

public class ResourceSetTest
extends TestCase {
    String XPathPrefix;
    String query1;
    String query2;
    int expected;
    private static final String URI = "xmldb:exist:///db";
    private static final String DRIVER = "org.exist.xmldb.DatabaseImpl";

    public ResourceSetTest(String arg0) {
        super(arg0);
    }

    protected void setUp() {
        try {
            Class<?> cl = Class.forName(DRIVER);
            Database database = (Database)cl.newInstance();
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)database);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (XMLDBException e) {
            ResourceSetTest.fail((String)e.getMessage());
        }
        this.XPathPrefix = "document('/db/test/shakes.xsl')/*/*";
        this.query1 = this.XPathPrefix + "[position()>=5 ]";
        this.query2 = this.XPathPrefix + "[position()<=10]";
        this.expected = 87;
    }

    public void testIntersection() {
        try {
            Collection testCollection = DatabaseManager.getCollection((String)"xmldb:exist:///db/test");
            ResourceSetTest.assertNotNull((Object)testCollection);
            XPathQueryService service = (XPathQueryService)testCollection.getService("XPathQueryService", "1.0");
            System.out.println("query1: " + this.query1);
            ResourceSet result1 = service.query(this.query1);
            System.out.println("query1: getSize()=" + result1.getSize());
            System.out.println("query2: " + this.query2);
            ResourceSet result2 = service.query(this.query2);
            System.out.println("query2: getSize()=" + result2.getSize());
            ResourceSetTest.assertEquals((String)("size of intersection of " + this.query1 + " and " + this.query2 + " yields "), (long)this.expected, (long)ResourceSetHelper.intersection(result1, result2).getSize());
        }
        catch (XMLDBException e) {
            ResourceSetTest.fail((String)e.getMessage());
        }
    }
}

